/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionAlg {
    AES128_CBC("AES128_CBC"),
    AES192_CBC("AES192_CBC"),
    AES256_CBC("AES256_CBC"),
    DES_EDE3_CBC("DES_EDE3_CBC"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionAlg> VALUE_MAP;
    private final String value;

    private EncryptionAlg(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionAlg fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionAlg> knownValues() {
        EnumSet<EncryptionAlg> knownValues = EnumSet.allOf(EncryptionAlg.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionAlg.class, EncryptionAlg::toString);
    }
}

