/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDirectoryListingRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, StartDirectoryListingRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(StartDirectoryListingRequest.getter(StartDirectoryListingRequest::connectorId)).setter(StartDirectoryListingRequest.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> REMOTE_DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDirectoryPath").getter(StartDirectoryListingRequest.getter(StartDirectoryListingRequest::remoteDirectoryPath)).setter(StartDirectoryListingRequest.setter(Builder::remoteDirectoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDirectoryPath").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(StartDirectoryListingRequest.getter(StartDirectoryListingRequest::maxItems)).setter(StartDirectoryListingRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> OUTPUT_DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputDirectoryPath").getter(StartDirectoryListingRequest.getter(StartDirectoryListingRequest::outputDirectoryPath)).setter(StartDirectoryListingRequest.setter(Builder::outputDirectoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDirectoryPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, REMOTE_DIRECTORY_PATH_FIELD, MAX_ITEMS_FIELD, OUTPUT_DIRECTORY_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDirectoryListingRequest.memberNameToFieldInitializer();
    private final String connectorId;
    private final String remoteDirectoryPath;
    private final Integer maxItems;
    private final String outputDirectoryPath;

    private StartDirectoryListingRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.remoteDirectoryPath = builder.remoteDirectoryPath;
        this.maxItems = builder.maxItems;
        this.outputDirectoryPath = builder.outputDirectoryPath;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String remoteDirectoryPath() {
        return this.remoteDirectoryPath;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String outputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDirectoryPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDirectoryListingRequest)) {
            return false;
        }
        StartDirectoryListingRequest other = (StartDirectoryListingRequest)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.remoteDirectoryPath(), other.remoteDirectoryPath()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.outputDirectoryPath(), other.outputDirectoryPath());
    }

    public final String toString() {
        return ToString.builder((String)"StartDirectoryListingRequest").add("ConnectorId", (Object)this.connectorId()).add("RemoteDirectoryPath", (Object)this.remoteDirectoryPath()).add("MaxItems", (Object)this.maxItems()).add("OutputDirectoryPath", (Object)this.outputDirectoryPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "RemoteDirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.remoteDirectoryPath()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "OutputDirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.outputDirectoryPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("RemoteDirectoryPath", REMOTE_DIRECTORY_PATH_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("OutputDirectoryPath", OUTPUT_DIRECTORY_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDirectoryListingRequest, T> g) {
        return obj -> g.apply((StartDirectoryListingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String remoteDirectoryPath;
        private Integer maxItems;
        private String outputDirectoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDirectoryListingRequest model) {
            super(model);
            this.connectorId(model.connectorId);
            this.remoteDirectoryPath(model.remoteDirectoryPath);
            this.maxItems(model.maxItems);
            this.outputDirectoryPath(model.outputDirectoryPath);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getRemoteDirectoryPath() {
            return this.remoteDirectoryPath;
        }

        public final void setRemoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
        }

        @Override
        public final Builder remoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getOutputDirectoryPath() {
            return this.outputDirectoryPath;
        }

        public final void setOutputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
        }

        @Override
        public final Builder outputDirectoryPath(String outputDirectoryPath) {
            this.outputDirectoryPath = outputDirectoryPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDirectoryListingRequest build() {
            return new StartDirectoryListingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDirectoryListingRequest> {
        public Builder connectorId(String var1);

        public Builder remoteDirectoryPath(String var1);

        public Builder maxItems(Integer var1);

        public Builder outputDirectoryPath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

