/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.CompressionEnum;
import software.amazon.awssdk.services.transfer.model.EncryptionAlg;
import software.amazon.awssdk.services.transfer.model.MdnResponse;
import software.amazon.awssdk.services.transfer.model.MdnSigningAlg;
import software.amazon.awssdk.services.transfer.model.SigningAlg;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class As2ConnectorConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, As2ConnectorConfig> {
    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalProfileId").getter(As2ConnectorConfig.getter(As2ConnectorConfig::localProfileId)).setter(As2ConnectorConfig.setter(Builder::localProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()}).build();
    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerProfileId").getter(As2ConnectorConfig.getter(As2ConnectorConfig::partnerProfileId)).setter(As2ConnectorConfig.setter(Builder::partnerProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()}).build();
    private static final SdkField<String> MESSAGE_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageSubject").getter(As2ConnectorConfig.getter(As2ConnectorConfig::messageSubject)).setter(As2ConnectorConfig.setter(Builder::messageSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSubject").build()}).build();
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compression").getter(As2ConnectorConfig.getter(As2ConnectorConfig::compressionAsString)).setter(As2ConnectorConfig.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()}).build();
    private static final SdkField<String> ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionAlgorithm").getter(As2ConnectorConfig.getter(As2ConnectorConfig::encryptionAlgorithmAsString)).setter(As2ConnectorConfig.setter(Builder::encryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAlgorithm").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(As2ConnectorConfig.getter(As2ConnectorConfig::signingAlgorithmAsString)).setter(As2ConnectorConfig.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<String> MDN_SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MdnSigningAlgorithm").getter(As2ConnectorConfig.getter(As2ConnectorConfig::mdnSigningAlgorithmAsString)).setter(As2ConnectorConfig.setter(Builder::mdnSigningAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MdnSigningAlgorithm").build()}).build();
    private static final SdkField<String> MDN_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MdnResponse").getter(As2ConnectorConfig.getter(As2ConnectorConfig::mdnResponseAsString)).setter(As2ConnectorConfig.setter(Builder::mdnResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MdnResponse").build()}).build();
    private static final SdkField<String> BASIC_AUTH_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BasicAuthSecretId").getter(As2ConnectorConfig.getter(As2ConnectorConfig::basicAuthSecretId)).setter(As2ConnectorConfig.setter(Builder::basicAuthSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthSecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD, MESSAGE_SUBJECT_FIELD, COMPRESSION_FIELD, ENCRYPTION_ALGORITHM_FIELD, SIGNING_ALGORITHM_FIELD, MDN_SIGNING_ALGORITHM_FIELD, MDN_RESPONSE_FIELD, BASIC_AUTH_SECRET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LocalProfileId", LOCAL_PROFILE_ID_FIELD);
            this.put("PartnerProfileId", PARTNER_PROFILE_ID_FIELD);
            this.put("MessageSubject", MESSAGE_SUBJECT_FIELD);
            this.put("Compression", COMPRESSION_FIELD);
            this.put("EncryptionAlgorithm", ENCRYPTION_ALGORITHM_FIELD);
            this.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
            this.put("MdnSigningAlgorithm", MDN_SIGNING_ALGORITHM_FIELD);
            this.put("MdnResponse", MDN_RESPONSE_FIELD);
            this.put("BasicAuthSecretId", BASIC_AUTH_SECRET_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String localProfileId;
    private final String partnerProfileId;
    private final String messageSubject;
    private final String compression;
    private final String encryptionAlgorithm;
    private final String signingAlgorithm;
    private final String mdnSigningAlgorithm;
    private final String mdnResponse;
    private final String basicAuthSecretId;

    private As2ConnectorConfig(BuilderImpl builder) {
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
        this.messageSubject = builder.messageSubject;
        this.compression = builder.compression;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.mdnSigningAlgorithm = builder.mdnSigningAlgorithm;
        this.mdnResponse = builder.mdnResponse;
        this.basicAuthSecretId = builder.basicAuthSecretId;
    }

    public final String localProfileId() {
        return this.localProfileId;
    }

    public final String partnerProfileId() {
        return this.partnerProfileId;
    }

    public final String messageSubject() {
        return this.messageSubject;
    }

    public final CompressionEnum compression() {
        return CompressionEnum.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final EncryptionAlg encryptionAlgorithm() {
        return EncryptionAlg.fromValue(this.encryptionAlgorithm);
    }

    public final String encryptionAlgorithmAsString() {
        return this.encryptionAlgorithm;
    }

    public final SigningAlg signingAlgorithm() {
        return SigningAlg.fromValue(this.signingAlgorithm);
    }

    public final String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public final MdnSigningAlg mdnSigningAlgorithm() {
        return MdnSigningAlg.fromValue(this.mdnSigningAlgorithm);
    }

    public final String mdnSigningAlgorithmAsString() {
        return this.mdnSigningAlgorithm;
    }

    public final MdnResponse mdnResponse() {
        return MdnResponse.fromValue(this.mdnResponse);
    }

    public final String mdnResponseAsString() {
        return this.mdnResponse;
    }

    public final String basicAuthSecretId() {
        return this.basicAuthSecretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mdnSigningAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mdnResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthSecretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof As2ConnectorConfig)) {
            return false;
        }
        As2ConnectorConfig other = (As2ConnectorConfig)obj;
        return Objects.equals(this.localProfileId(), other.localProfileId()) && Objects.equals(this.partnerProfileId(), other.partnerProfileId()) && Objects.equals(this.messageSubject(), other.messageSubject()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.encryptionAlgorithmAsString(), other.encryptionAlgorithmAsString()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString()) && Objects.equals(this.mdnSigningAlgorithmAsString(), other.mdnSigningAlgorithmAsString()) && Objects.equals(this.mdnResponseAsString(), other.mdnResponseAsString()) && Objects.equals(this.basicAuthSecretId(), other.basicAuthSecretId());
    }

    public final String toString() {
        return ToString.builder((String)"As2ConnectorConfig").add("LocalProfileId", (Object)this.localProfileId()).add("PartnerProfileId", (Object)this.partnerProfileId()).add("MessageSubject", (Object)this.messageSubject()).add("Compression", (Object)this.compressionAsString()).add("EncryptionAlgorithm", (Object)this.encryptionAlgorithmAsString()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).add("MdnSigningAlgorithm", (Object)this.mdnSigningAlgorithmAsString()).add("MdnResponse", (Object)this.mdnResponseAsString()).add("BasicAuthSecretId", (Object)this.basicAuthSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalProfileId": {
                return Optional.ofNullable(clazz.cast(this.localProfileId()));
            }
            case "PartnerProfileId": {
                return Optional.ofNullable(clazz.cast(this.partnerProfileId()));
            }
            case "MessageSubject": {
                return Optional.ofNullable(clazz.cast(this.messageSubject()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "EncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmAsString()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
            case "MdnSigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.mdnSigningAlgorithmAsString()));
            }
            case "MdnResponse": {
                return Optional.ofNullable(clazz.cast(this.mdnResponseAsString()));
            }
            case "BasicAuthSecretId": {
                return Optional.ofNullable(clazz.cast(this.basicAuthSecretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<As2ConnectorConfig, T> g) {
        return obj -> g.apply((As2ConnectorConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localProfileId;
        private String partnerProfileId;
        private String messageSubject;
        private String compression;
        private String encryptionAlgorithm;
        private String signingAlgorithm;
        private String mdnSigningAlgorithm;
        private String mdnResponse;
        private String basicAuthSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(As2ConnectorConfig model) {
            this.localProfileId(model.localProfileId);
            this.partnerProfileId(model.partnerProfileId);
            this.messageSubject(model.messageSubject);
            this.compression(model.compression);
            this.encryptionAlgorithm(model.encryptionAlgorithm);
            this.signingAlgorithm(model.signingAlgorithm);
            this.mdnSigningAlgorithm(model.mdnSigningAlgorithm);
            this.mdnResponse(model.mdnResponse);
            this.basicAuthSecretId(model.basicAuthSecretId);
        }

        public final String getLocalProfileId() {
            return this.localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public final String getMessageSubject() {
            return this.messageSubject;
        }

        public final void setMessageSubject(String messageSubject) {
            this.messageSubject = messageSubject;
        }

        @Override
        public final Builder messageSubject(String messageSubject) {
            this.messageSubject = messageSubject;
            return this;
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionEnum compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public final void setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        @Override
        public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder encryptionAlgorithm(EncryptionAlg encryptionAlgorithm) {
            this.encryptionAlgorithm(encryptionAlgorithm == null ? null : encryptionAlgorithm.toString());
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlg signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final String getMdnSigningAlgorithm() {
            return this.mdnSigningAlgorithm;
        }

        public final void setMdnSigningAlgorithm(String mdnSigningAlgorithm) {
            this.mdnSigningAlgorithm = mdnSigningAlgorithm;
        }

        @Override
        public final Builder mdnSigningAlgorithm(String mdnSigningAlgorithm) {
            this.mdnSigningAlgorithm = mdnSigningAlgorithm;
            return this;
        }

        @Override
        public final Builder mdnSigningAlgorithm(MdnSigningAlg mdnSigningAlgorithm) {
            this.mdnSigningAlgorithm(mdnSigningAlgorithm == null ? null : mdnSigningAlgorithm.toString());
            return this;
        }

        public final String getMdnResponse() {
            return this.mdnResponse;
        }

        public final void setMdnResponse(String mdnResponse) {
            this.mdnResponse = mdnResponse;
        }

        @Override
        public final Builder mdnResponse(String mdnResponse) {
            this.mdnResponse = mdnResponse;
            return this;
        }

        @Override
        public final Builder mdnResponse(MdnResponse mdnResponse) {
            this.mdnResponse(mdnResponse == null ? null : mdnResponse.toString());
            return this;
        }

        public final String getBasicAuthSecretId() {
            return this.basicAuthSecretId;
        }

        public final void setBasicAuthSecretId(String basicAuthSecretId) {
            this.basicAuthSecretId = basicAuthSecretId;
        }

        @Override
        public final Builder basicAuthSecretId(String basicAuthSecretId) {
            this.basicAuthSecretId = basicAuthSecretId;
            return this;
        }

        public As2ConnectorConfig build() {
            return new As2ConnectorConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, As2ConnectorConfig> {
        public Builder localProfileId(String var1);

        public Builder partnerProfileId(String var1);

        public Builder messageSubject(String var1);

        public Builder compression(String var1);

        public Builder compression(CompressionEnum var1);

        public Builder encryptionAlgorithm(String var1);

        public Builder encryptionAlgorithm(EncryptionAlg var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlg var1);

        public Builder mdnSigningAlgorithm(String var1);

        public Builder mdnSigningAlgorithm(MdnSigningAlg var1);

        public Builder mdnResponse(String var1);

        public Builder mdnResponse(MdnResponse var1);

        public Builder basicAuthSecretId(String var1);
    }
}

