/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.SftpConnectorTrustedHostKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SftpConnectorConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SftpConnectorConfig> {
    private static final SdkField<String> USER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserSecretId").getter(SftpConnectorConfig.getter(SftpConnectorConfig::userSecretId)).setter(SftpConnectorConfig.setter(Builder::userSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSecretId").build()}).build();
    private static final SdkField<List<String>> TRUSTED_HOST_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustedHostKeys").getter(SftpConnectorConfig.getter(SftpConnectorConfig::trustedHostKeys)).setter(SftpConnectorConfig.setter(Builder::trustedHostKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedHostKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_SECRET_ID_FIELD, TRUSTED_HOST_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SftpConnectorConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userSecretId;
    private final List<String> trustedHostKeys;

    private SftpConnectorConfig(BuilderImpl builder) {
        this.userSecretId = builder.userSecretId;
        this.trustedHostKeys = builder.trustedHostKeys;
    }

    public final String userSecretId() {
        return this.userSecretId;
    }

    public final boolean hasTrustedHostKeys() {
        return this.trustedHostKeys != null && !(this.trustedHostKeys instanceof SdkAutoConstructList);
    }

    public final List<String> trustedHostKeys() {
        return this.trustedHostKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustedHostKeys() ? this.trustedHostKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SftpConnectorConfig)) {
            return false;
        }
        SftpConnectorConfig other = (SftpConnectorConfig)obj;
        return Objects.equals(this.userSecretId(), other.userSecretId()) && this.hasTrustedHostKeys() == other.hasTrustedHostKeys() && Objects.equals(this.trustedHostKeys(), other.trustedHostKeys());
    }

    public final String toString() {
        return ToString.builder((String)"SftpConnectorConfig").add("UserSecretId", (Object)this.userSecretId()).add("TrustedHostKeys", this.hasTrustedHostKeys() ? this.trustedHostKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserSecretId": {
                return Optional.ofNullable(clazz.cast(this.userSecretId()));
            }
            case "TrustedHostKeys": {
                return Optional.ofNullable(clazz.cast(this.trustedHostKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserSecretId", USER_SECRET_ID_FIELD);
        map.put("TrustedHostKeys", TRUSTED_HOST_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SftpConnectorConfig, T> g) {
        return obj -> g.apply((SftpConnectorConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userSecretId;
        private List<String> trustedHostKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SftpConnectorConfig model) {
            this.userSecretId(model.userSecretId);
            this.trustedHostKeys(model.trustedHostKeys);
        }

        public final String getUserSecretId() {
            return this.userSecretId;
        }

        public final void setUserSecretId(String userSecretId) {
            this.userSecretId = userSecretId;
        }

        @Override
        public final Builder userSecretId(String userSecretId) {
            this.userSecretId = userSecretId;
            return this;
        }

        public final Collection<String> getTrustedHostKeys() {
            if (this.trustedHostKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trustedHostKeys;
        }

        public final void setTrustedHostKeys(Collection<String> trustedHostKeys) {
            this.trustedHostKeys = SftpConnectorTrustedHostKeyListCopier.copy(trustedHostKeys);
        }

        @Override
        public final Builder trustedHostKeys(Collection<String> trustedHostKeys) {
            this.trustedHostKeys = SftpConnectorTrustedHostKeyListCopier.copy(trustedHostKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedHostKeys(String ... trustedHostKeys) {
            this.trustedHostKeys(Arrays.asList(trustedHostKeys));
            return this;
        }

        public SftpConnectorConfig build() {
            return new SftpConnectorConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SftpConnectorConfig> {
        public Builder userSecretId(String var1);

        public Builder trustedHostKeys(Collection<String> var1);

        public Builder trustedHostKeys(String ... var1);
    }
}

