/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.AgreementStatusType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgreementRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, CreateAgreementRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateAgreementRequest.getter(CreateAgreementRequest::description)).setter(CreateAgreementRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(CreateAgreementRequest.getter(CreateAgreementRequest::serverId)).setter(CreateAgreementRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalProfileId").getter(CreateAgreementRequest.getter(CreateAgreementRequest::localProfileId)).setter(CreateAgreementRequest.setter(Builder::localProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()}).build();
    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerProfileId").getter(CreateAgreementRequest.getter(CreateAgreementRequest::partnerProfileId)).setter(CreateAgreementRequest.setter(Builder::partnerProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()}).build();
    private static final SdkField<String> BASE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseDirectory").getter(CreateAgreementRequest.getter(CreateAgreementRequest::baseDirectory)).setter(CreateAgreementRequest.setter(Builder::baseDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseDirectory").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRole").getter(CreateAgreementRequest.getter(CreateAgreementRequest::accessRole)).setter(CreateAgreementRequest.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateAgreementRequest.getter(CreateAgreementRequest::statusAsString)).setter(CreateAgreementRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAgreementRequest.getter(CreateAgreementRequest::tags)).setter(CreateAgreementRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, SERVER_ID_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD, BASE_DIRECTORY_FIELD, ACCESS_ROLE_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAgreementRequest.memberNameToFieldInitializer();
    private final String description;
    private final String serverId;
    private final String localProfileId;
    private final String partnerProfileId;
    private final String baseDirectory;
    private final String accessRole;
    private final String status;
    private final List<Tag> tags;

    private CreateAgreementRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.serverId = builder.serverId;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
        this.baseDirectory = builder.baseDirectory;
        this.accessRole = builder.accessRole;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String localProfileId() {
        return this.localProfileId;
    }

    public final String partnerProfileId() {
        return this.partnerProfileId;
    }

    public final String baseDirectory() {
        return this.baseDirectory;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgreementRequest)) {
            return false;
        }
        CreateAgreementRequest other = (CreateAgreementRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.localProfileId(), other.localProfileId()) && Objects.equals(this.partnerProfileId(), other.partnerProfileId()) && Objects.equals(this.baseDirectory(), other.baseDirectory()) && Objects.equals(this.accessRole(), other.accessRole()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgreementRequest").add("Description", (Object)this.description()).add("ServerId", (Object)this.serverId()).add("LocalProfileId", (Object)this.localProfileId()).add("PartnerProfileId", (Object)this.partnerProfileId()).add("BaseDirectory", (Object)this.baseDirectory()).add("AccessRole", (Object)this.accessRole()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "LocalProfileId": {
                return Optional.ofNullable(clazz.cast(this.localProfileId()));
            }
            case "PartnerProfileId": {
                return Optional.ofNullable(clazz.cast(this.partnerProfileId()));
            }
            case "BaseDirectory": {
                return Optional.ofNullable(clazz.cast(this.baseDirectory()));
            }
            case "AccessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("LocalProfileId", LOCAL_PROFILE_ID_FIELD);
        map.put("PartnerProfileId", PARTNER_PROFILE_ID_FIELD);
        map.put("BaseDirectory", BASE_DIRECTORY_FIELD);
        map.put("AccessRole", ACCESS_ROLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgreementRequest, T> g) {
        return obj -> g.apply((CreateAgreementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String description;
        private String serverId;
        private String localProfileId;
        private String partnerProfileId;
        private String baseDirectory;
        private String accessRole;
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgreementRequest model) {
            super(model);
            this.description(model.description);
            this.serverId(model.serverId);
            this.localProfileId(model.localProfileId);
            this.partnerProfileId(model.partnerProfileId);
            this.baseDirectory(model.baseDirectory);
            this.accessRole(model.accessRole);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getLocalProfileId() {
            return this.localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public final String getBaseDirectory() {
            return this.baseDirectory;
        }

        public final void setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        @Override
        public final Builder baseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgreementRequest build() {
            return new CreateAgreementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgreementRequest> {
        public Builder description(String var1);

        public Builder serverId(String var1);

        public Builder localProfileId(String var1);

        public Builder partnerProfileId(String var1);

        public Builder baseDirectory(String var1);

        public Builder accessRole(String var1);

        public Builder status(String var1);

        public Builder status(AgreementStatusType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

