/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.AgreementStatusType;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgreementRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateAgreementRequest> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgreementId").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::agreementId)).setter(UpdateAgreementRequest.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::serverId)).setter(UpdateAgreementRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::description)).setter(UpdateAgreementRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::statusAsString)).setter(UpdateAgreementRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalProfileId").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::localProfileId)).setter(UpdateAgreementRequest.setter(Builder::localProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()}).build();
    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerProfileId").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::partnerProfileId)).setter(UpdateAgreementRequest.setter(Builder::partnerProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()}).build();
    private static final SdkField<String> BASE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseDirectory").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::baseDirectory)).setter(UpdateAgreementRequest.setter(Builder::baseDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseDirectory").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRole").getter(UpdateAgreementRequest.getter(UpdateAgreementRequest::accessRole)).setter(UpdateAgreementRequest.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD, SERVER_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD, BASE_DIRECTORY_FIELD, ACCESS_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgreementRequest.memberNameToFieldInitializer();
    private final String agreementId;
    private final String serverId;
    private final String description;
    private final String status;
    private final String localProfileId;
    private final String partnerProfileId;
    private final String baseDirectory;
    private final String accessRole;

    private UpdateAgreementRequest(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.serverId = builder.serverId;
        this.description = builder.description;
        this.status = builder.status;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
        this.baseDirectory = builder.baseDirectory;
        this.accessRole = builder.accessRole;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String description() {
        return this.description;
    }

    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String localProfileId() {
        return this.localProfileId;
    }

    public final String partnerProfileId() {
        return this.partnerProfileId;
    }

    public final String baseDirectory() {
        return this.baseDirectory;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgreementRequest)) {
            return false;
        }
        UpdateAgreementRequest other = (UpdateAgreementRequest)((Object)obj);
        return Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.localProfileId(), other.localProfileId()) && Objects.equals(this.partnerProfileId(), other.partnerProfileId()) && Objects.equals(this.baseDirectory(), other.baseDirectory()) && Objects.equals(this.accessRole(), other.accessRole());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgreementRequest").add("AgreementId", (Object)this.agreementId()).add("ServerId", (Object)this.serverId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("LocalProfileId", (Object)this.localProfileId()).add("PartnerProfileId", (Object)this.partnerProfileId()).add("BaseDirectory", (Object)this.baseDirectory()).add("AccessRole", (Object)this.accessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LocalProfileId": {
                return Optional.ofNullable(clazz.cast(this.localProfileId()));
            }
            case "PartnerProfileId": {
                return Optional.ofNullable(clazz.cast(this.partnerProfileId()));
            }
            case "BaseDirectory": {
                return Optional.ofNullable(clazz.cast(this.baseDirectory()));
            }
            case "AccessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AgreementId", AGREEMENT_ID_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LocalProfileId", LOCAL_PROFILE_ID_FIELD);
        map.put("PartnerProfileId", PARTNER_PROFILE_ID_FIELD);
        map.put("BaseDirectory", BASE_DIRECTORY_FIELD);
        map.put("AccessRole", ACCESS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgreementRequest, T> g) {
        return obj -> g.apply((UpdateAgreementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String agreementId;
        private String serverId;
        private String description;
        private String status;
        private String localProfileId;
        private String partnerProfileId;
        private String baseDirectory;
        private String accessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgreementRequest model) {
            super(model);
            this.agreementId(model.agreementId);
            this.serverId(model.serverId);
            this.description(model.description);
            this.status(model.status);
            this.localProfileId(model.localProfileId);
            this.partnerProfileId(model.partnerProfileId);
            this.baseDirectory(model.baseDirectory);
            this.accessRole(model.accessRole);
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLocalProfileId() {
            return this.localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public final String getBaseDirectory() {
            return this.baseDirectory;
        }

        public final void setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        @Override
        public final Builder baseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgreementRequest build() {
            return new UpdateAgreementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgreementRequest> {
        public Builder agreementId(String var1);

        public Builder serverId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AgreementStatusType var1);

        public Builder localProfileId(String var1);

        public Builder partnerProfileId(String var1);

        public Builder baseDirectory(String var1);

        public Builder accessRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

