/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.EfsFileLocation;
import software.amazon.awssdk.services.transfer.model.S3InputFileLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFileLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputFileLocation> {
    private static final SdkField<S3InputFileLocation> S3_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3FileLocation").getter(InputFileLocation.getter(InputFileLocation::s3FileLocation)).setter(InputFileLocation.setter(Builder::s3FileLocation)).constructor(S3InputFileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3FileLocation").build()}).build();
    private static final SdkField<EfsFileLocation> EFS_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EfsFileLocation").getter(InputFileLocation.getter(InputFileLocation::efsFileLocation)).setter(InputFileLocation.setter(Builder::efsFileLocation)).constructor(EfsFileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFileLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FILE_LOCATION_FIELD, EFS_FILE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3FileLocation", S3_FILE_LOCATION_FIELD);
            this.put("EfsFileLocation", EFS_FILE_LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3InputFileLocation s3FileLocation;
    private final EfsFileLocation efsFileLocation;

    private InputFileLocation(BuilderImpl builder) {
        this.s3FileLocation = builder.s3FileLocation;
        this.efsFileLocation = builder.efsFileLocation;
    }

    public final S3InputFileLocation s3FileLocation() {
        return this.s3FileLocation;
    }

    public final EfsFileLocation efsFileLocation() {
        return this.efsFileLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3FileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFileLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFileLocation)) {
            return false;
        }
        InputFileLocation other = (InputFileLocation)obj;
        return Objects.equals(this.s3FileLocation(), other.s3FileLocation()) && Objects.equals(this.efsFileLocation(), other.efsFileLocation());
    }

    public final String toString() {
        return ToString.builder((String)"InputFileLocation").add("S3FileLocation", (Object)this.s3FileLocation()).add("EfsFileLocation", (Object)this.efsFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3FileLocation": {
                return Optional.ofNullable(clazz.cast(this.s3FileLocation()));
            }
            case "EfsFileLocation": {
                return Optional.ofNullable(clazz.cast(this.efsFileLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputFileLocation, T> g) {
        return obj -> g.apply((InputFileLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3InputFileLocation s3FileLocation;
        private EfsFileLocation efsFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFileLocation model) {
            this.s3FileLocation(model.s3FileLocation);
            this.efsFileLocation(model.efsFileLocation);
        }

        public final S3InputFileLocation.Builder getS3FileLocation() {
            return this.s3FileLocation != null ? this.s3FileLocation.toBuilder() : null;
        }

        public final void setS3FileLocation(S3InputFileLocation.BuilderImpl s3FileLocation) {
            this.s3FileLocation = s3FileLocation != null ? s3FileLocation.build() : null;
        }

        @Override
        public final Builder s3FileLocation(S3InputFileLocation s3FileLocation) {
            this.s3FileLocation = s3FileLocation;
            return this;
        }

        public final EfsFileLocation.Builder getEfsFileLocation() {
            return this.efsFileLocation != null ? this.efsFileLocation.toBuilder() : null;
        }

        public final void setEfsFileLocation(EfsFileLocation.BuilderImpl efsFileLocation) {
            this.efsFileLocation = efsFileLocation != null ? efsFileLocation.build() : null;
        }

        @Override
        public final Builder efsFileLocation(EfsFileLocation efsFileLocation) {
            this.efsFileLocation = efsFileLocation;
            return this;
        }

        public InputFileLocation build() {
            return new InputFileLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputFileLocation> {
        public Builder s3FileLocation(S3InputFileLocation var1);

        default public Builder s3FileLocation(Consumer<S3InputFileLocation.Builder> s3FileLocation) {
            return this.s3FileLocation((S3InputFileLocation)((S3InputFileLocation.Builder)S3InputFileLocation.builder().applyMutation(s3FileLocation)).build());
        }

        public Builder efsFileLocation(EfsFileLocation var1);

        default public Builder efsFileLocation(Consumer<EfsFileLocation.Builder> efsFileLocation) {
            return this.efsFileLocation((EfsFileLocation)((EfsFileLocation.Builder)EfsFileLocation.builder().applyMutation(efsFileLocation)).build());
        }
    }
}

