/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult;
import software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResultsCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFileTransferResultsResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListFileTransferResultsResponse> {
    private static final SdkField<List<ConnectorFileTransferResult>> FILE_TRANSFER_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileTransferResults").getter(ListFileTransferResultsResponse.getter(ListFileTransferResultsResponse::fileTransferResults)).setter(ListFileTransferResultsResponse.setter(Builder::fileTransferResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileTransferResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorFileTransferResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFileTransferResultsResponse.getter(ListFileTransferResultsResponse::nextToken)).setter(ListFileTransferResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TRANSFER_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FileTransferResults", FILE_TRANSFER_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConnectorFileTransferResult> fileTransferResults;
    private final String nextToken;

    private ListFileTransferResultsResponse(BuilderImpl builder) {
        super(builder);
        this.fileTransferResults = builder.fileTransferResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFileTransferResults() {
        return this.fileTransferResults != null && !(this.fileTransferResults instanceof SdkAutoConstructList);
    }

    public final List<ConnectorFileTransferResult> fileTransferResults() {
        return this.fileTransferResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileTransferResults() ? this.fileTransferResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileTransferResultsResponse)) {
            return false;
        }
        ListFileTransferResultsResponse other = (ListFileTransferResultsResponse)((Object)obj);
        return this.hasFileTransferResults() == other.hasFileTransferResults() && Objects.equals(this.fileTransferResults(), other.fileTransferResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFileTransferResultsResponse").add("FileTransferResults", this.hasFileTransferResults() ? this.fileTransferResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileTransferResults": {
                return Optional.ofNullable(clazz.cast(this.fileTransferResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFileTransferResultsResponse, T> g) {
        return obj -> g.apply((ListFileTransferResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private List<ConnectorFileTransferResult> fileTransferResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileTransferResultsResponse model) {
            super(model);
            this.fileTransferResults(model.fileTransferResults);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectorFileTransferResult.Builder> getFileTransferResults() {
            List<ConnectorFileTransferResult.Builder> result = ConnectorFileTransferResultsCopier.copyToBuilder(this.fileTransferResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileTransferResults(Collection<ConnectorFileTransferResult.BuilderImpl> fileTransferResults) {
            this.fileTransferResults = ConnectorFileTransferResultsCopier.copyFromBuilder(fileTransferResults);
        }

        @Override
        public final Builder fileTransferResults(Collection<ConnectorFileTransferResult> fileTransferResults) {
            this.fileTransferResults = ConnectorFileTransferResultsCopier.copy(fileTransferResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileTransferResults(ConnectorFileTransferResult ... fileTransferResults) {
            this.fileTransferResults(Arrays.asList(fileTransferResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileTransferResults(Consumer<ConnectorFileTransferResult.Builder> ... fileTransferResults) {
            this.fileTransferResults(Stream.of(fileTransferResults).map(c -> (ConnectorFileTransferResult)((ConnectorFileTransferResult.Builder)ConnectorFileTransferResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFileTransferResultsResponse build() {
            return new ListFileTransferResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFileTransferResultsResponse> {
        public Builder fileTransferResults(Collection<ConnectorFileTransferResult> var1);

        public Builder fileTransferResults(ConnectorFileTransferResult ... var1);

        public Builder fileTransferResults(Consumer<ConnectorFileTransferResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

