/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.S3Tag;
import software.amazon.awssdk.services.transfer.model.S3TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagStepDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TagStepDetails.getter(TagStepDetails::name)).setter(TagStepDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<S3Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TagStepDetails.getter(TagStepDetails::tags)).setter(TagStepDetails.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileLocation").getter(TagStepDetails.getter(TagStepDetails::sourceFileLocation)).setter(TagStepDetails.setter(Builder::sourceFileLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TAGS_FIELD, SOURCE_FILE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("SourceFileLocation", SOURCE_FILE_LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<S3Tag> tags;
    private final String sourceFileLocation;

    private TagStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.tags = builder.tags;
        this.sourceFileLocation = builder.sourceFileLocation;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<S3Tag> tags() {
        return this.tags;
    }

    public final String sourceFileLocation() {
        return this.sourceFileLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagStepDetails)) {
            return false;
        }
        TagStepDetails other = (TagStepDetails)obj;
        return Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sourceFileLocation(), other.sourceFileLocation());
    }

    public final String toString() {
        return ToString.builder((String)"TagStepDetails").add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("SourceFileLocation", (Object)this.sourceFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SourceFileLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceFileLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TagStepDetails, T> g) {
        return obj -> g.apply((TagStepDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<S3Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String sourceFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(TagStepDetails model) {
            this.name(model.name);
            this.tags(model.tags);
            this.sourceFileLocation(model.sourceFileLocation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<S3Tag.Builder> getTags() {
            List<S3Tag.Builder> result = S3TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<S3Tag.BuilderImpl> tags) {
            this.tags = S3TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<S3Tag> tags) {
            this.tags = S3TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(S3Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<S3Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceFileLocation() {
            return this.sourceFileLocation;
        }

        public final void setSourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
        }

        @Override
        public final Builder sourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
            return this;
        }

        public TagStepDetails build() {
            return new TagStepDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagStepDetails> {
        public Builder name(String var1);

        public Builder tags(Collection<S3Tag> var1);

        public Builder tags(S3Tag ... var1);

        public Builder tags(Consumer<S3Tag.Builder> ... var1);

        public Builder sourceFileLocation(String var1);
    }
}

