/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.Protocol;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestIdentityProviderRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, TestIdentityProviderRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(TestIdentityProviderRequest.getter(TestIdentityProviderRequest::serverId)).setter(TestIdentityProviderRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerProtocol").getter(TestIdentityProviderRequest.getter(TestIdentityProviderRequest::serverProtocolAsString)).setter(TestIdentityProviderRequest.setter(Builder::serverProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()}).build();
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIp").getter(TestIdentityProviderRequest.getter(TestIdentityProviderRequest::sourceIp)).setter(TestIdentityProviderRequest.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(TestIdentityProviderRequest.getter(TestIdentityProviderRequest::userName)).setter(TestIdentityProviderRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPassword").getter(TestIdentityProviderRequest.getter(TestIdentityProviderRequest::userPassword)).setter(TestIdentityProviderRequest.setter(Builder::userPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, SERVER_PROTOCOL_FIELD, SOURCE_IP_FIELD, USER_NAME_FIELD, USER_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServerId", SERVER_ID_FIELD);
            this.put("ServerProtocol", SERVER_PROTOCOL_FIELD);
            this.put("SourceIp", SOURCE_IP_FIELD);
            this.put("UserName", USER_NAME_FIELD);
            this.put("UserPassword", USER_PASSWORD_FIELD);
        }
    });
    private final String serverId;
    private final String serverProtocol;
    private final String sourceIp;
    private final String userName;
    private final String userPassword;

    private TestIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.serverProtocol = builder.serverProtocol;
        this.sourceIp = builder.sourceIp;
        this.userName = builder.userName;
        this.userPassword = builder.userPassword;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final Protocol serverProtocol() {
        return Protocol.fromValue(this.serverProtocol);
    }

    public final String serverProtocolAsString() {
        return this.serverProtocol;
    }

    public final String sourceIp() {
        return this.sourceIp;
    }

    public final String userName() {
        return this.userName;
    }

    public final String userPassword() {
        return this.userPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestIdentityProviderRequest)) {
            return false;
        }
        TestIdentityProviderRequest other = (TestIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.serverProtocolAsString(), other.serverProtocolAsString()) && Objects.equals(this.sourceIp(), other.sourceIp()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userPassword(), other.userPassword());
    }

    public final String toString() {
        return ToString.builder((String)"TestIdentityProviderRequest").add("ServerId", (Object)this.serverId()).add("ServerProtocol", (Object)this.serverProtocolAsString()).add("SourceIp", (Object)this.sourceIp()).add("UserName", (Object)this.userName()).add("UserPassword", (Object)(this.userPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "ServerProtocol": {
                return Optional.ofNullable(clazz.cast(this.serverProtocolAsString()));
            }
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIp()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "UserPassword": {
                return Optional.ofNullable(clazz.cast(this.userPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestIdentityProviderRequest, T> g) {
        return obj -> g.apply((TestIdentityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String serverId;
        private String serverProtocol;
        private String sourceIp;
        private String userName;
        private String userPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(TestIdentityProviderRequest model) {
            super(model);
            this.serverId(model.serverId);
            this.serverProtocol(model.serverProtocol);
            this.sourceIp(model.sourceIp);
            this.userName(model.userName);
            this.userPassword(model.userPassword);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getServerProtocol() {
            return this.serverProtocol;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(Protocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserPassword() {
            return this.userPassword;
        }

        public final void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        @Override
        public final Builder userPassword(String userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestIdentityProviderRequest build() {
            return new TestIdentityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestIdentityProviderRequest> {
        public Builder serverId(String var1);

        public Builder serverProtocol(String var1);

        public Builder serverProtocol(Protocol var1);

        public Builder sourceIp(String var1);

        public Builder userName(String var1);

        public Builder userPassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

