/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDirectoryListingResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, StartDirectoryListingResponse> {
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListingId").getter(StartDirectoryListingResponse.getter(StartDirectoryListingResponse::listingId)).setter(StartDirectoryListingResponse.setter(Builder::listingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListingId").build()}).build();
    private static final SdkField<String> OUTPUT_FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFileName").getter(StartDirectoryListingResponse.getter(StartDirectoryListingResponse::outputFileName)).setter(StartDirectoryListingResponse.setter(Builder::outputFileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_ID_FIELD, OUTPUT_FILE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ListingId", LISTING_ID_FIELD);
            this.put("OutputFileName", OUTPUT_FILE_NAME_FIELD);
        }
    });
    private final String listingId;
    private final String outputFileName;

    private StartDirectoryListingResponse(BuilderImpl builder) {
        super(builder);
        this.listingId = builder.listingId;
        this.outputFileName = builder.outputFileName;
    }

    public final String listingId() {
        return this.listingId;
    }

    public final String outputFileName() {
        return this.outputFileName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDirectoryListingResponse)) {
            return false;
        }
        StartDirectoryListingResponse other = (StartDirectoryListingResponse)((Object)obj);
        return Objects.equals(this.listingId(), other.listingId()) && Objects.equals(this.outputFileName(), other.outputFileName());
    }

    public final String toString() {
        return ToString.builder((String)"StartDirectoryListingResponse").add("ListingId", (Object)this.listingId()).add("OutputFileName", (Object)this.outputFileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListingId": {
                return Optional.ofNullable(clazz.cast(this.listingId()));
            }
            case "OutputFileName": {
                return Optional.ofNullable(clazz.cast(this.outputFileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartDirectoryListingResponse, T> g) {
        return obj -> g.apply((StartDirectoryListingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String listingId;
        private String outputFileName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDirectoryListingResponse model) {
            super(model);
            this.listingId(model.listingId);
            this.outputFileName(model.outputFileName);
        }

        public final String getListingId() {
            return this.listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getOutputFileName() {
            return this.outputFileName;
        }

        public final void setOutputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
        }

        @Override
        public final Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        @Override
        public StartDirectoryListingResponse build() {
            return new StartDirectoryListingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDirectoryListingResponse> {
        public Builder listingId(String var1);

        public Builder outputFileName(String var1);
    }
}

