/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.CertificateStatusType;
import software.amazon.awssdk.services.transfer.model.CertificateType;
import software.amazon.awssdk.services.transfer.model.CertificateUsageType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedCertificate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedCertificate.getter(DescribedCertificate::arn)).setter(DescribedCertificate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(DescribedCertificate.getter(DescribedCertificate::certificateId)).setter(DescribedCertificate.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Usage").getter(DescribedCertificate.getter(DescribedCertificate::usageAsString)).setter(DescribedCertificate.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribedCertificate.getter(DescribedCertificate::statusAsString)).setter(DescribedCertificate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(DescribedCertificate.getter(DescribedCertificate::certificate)).setter(DescribedCertificate.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateChain").getter(DescribedCertificate.getter(DescribedCertificate::certificateChain)).setter(DescribedCertificate.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActiveDate").getter(DescribedCertificate.getter(DescribedCertificate::activeDate)).setter(DescribedCertificate.setter(Builder::activeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()}).build();
    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InactiveDate").getter(DescribedCertificate.getter(DescribedCertificate::inactiveDate)).setter(DescribedCertificate.setter(Builder::inactiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()}).build();
    private static final SdkField<String> SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Serial").getter(DescribedCertificate.getter(DescribedCertificate::serial)).setter(DescribedCertificate.setter(Builder::serial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotBeforeDate").getter(DescribedCertificate.getter(DescribedCertificate::notBeforeDate)).setter(DescribedCertificate.setter(Builder::notBeforeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBeforeDate").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotAfterDate").getter(DescribedCertificate.getter(DescribedCertificate::notAfterDate)).setter(DescribedCertificate.setter(Builder::notAfterDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfterDate").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribedCertificate.getter(DescribedCertificate::typeAsString)).setter(DescribedCertificate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribedCertificate.getter(DescribedCertificate::description)).setter(DescribedCertificate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedCertificate.getter(DescribedCertificate::tags)).setter(DescribedCertificate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATE_ID_FIELD, USAGE_FIELD, STATUS_FIELD, CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, SERIAL_FIELD, NOT_BEFORE_DATE_FIELD, NOT_AFTER_DATE_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String certificateId;
    private final String usage;
    private final String status;
    private final String certificate;
    private final String certificateChain;
    private final Instant activeDate;
    private final Instant inactiveDate;
    private final String serial;
    private final Instant notBeforeDate;
    private final Instant notAfterDate;
    private final String type;
    private final String description;
    private final List<Tag> tags;

    private DescribedCertificate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateId = builder.certificateId;
        this.usage = builder.usage;
        this.status = builder.status;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.serial = builder.serial;
        this.notBeforeDate = builder.notBeforeDate;
        this.notAfterDate = builder.notAfterDate;
        this.type = builder.type;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(this.usage);
    }

    public final String usageAsString() {
        return this.usage;
    }

    public final CertificateStatusType status() {
        return CertificateStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final String certificateChain() {
        return this.certificateChain;
    }

    public final Instant activeDate() {
        return this.activeDate;
    }

    public final Instant inactiveDate() {
        return this.inactiveDate;
    }

    public final String serial() {
        return this.serial;
    }

    public final Instant notBeforeDate() {
        return this.notBeforeDate;
    }

    public final Instant notAfterDate() {
        return this.notAfterDate;
    }

    public final CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBeforeDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfterDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedCertificate)) {
            return false;
        }
        DescribedCertificate other = (DescribedCertificate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.usageAsString(), other.usageAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.activeDate(), other.activeDate()) && Objects.equals(this.inactiveDate(), other.inactiveDate()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.notBeforeDate(), other.notBeforeDate()) && Objects.equals(this.notAfterDate(), other.notAfterDate()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedCertificate").add("Arn", (Object)this.arn()).add("CertificateId", (Object)this.certificateId()).add("Usage", (Object)this.usageAsString()).add("Status", (Object)this.statusAsString()).add("Certificate", (Object)(this.certificate() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateChain", (Object)(this.certificateChain() == null ? null : "*** Sensitive Data Redacted ***")).add("ActiveDate", (Object)this.activeDate()).add("InactiveDate", (Object)this.inactiveDate()).add("Serial", (Object)this.serial()).add("NotBeforeDate", (Object)this.notBeforeDate()).add("NotAfterDate", (Object)this.notAfterDate()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "Usage": {
                return Optional.ofNullable(clazz.cast(this.usageAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "ActiveDate": {
                return Optional.ofNullable(clazz.cast(this.activeDate()));
            }
            case "InactiveDate": {
                return Optional.ofNullable(clazz.cast(this.inactiveDate()));
            }
            case "Serial": {
                return Optional.ofNullable(clazz.cast(this.serial()));
            }
            case "NotBeforeDate": {
                return Optional.ofNullable(clazz.cast(this.notBeforeDate()));
            }
            case "NotAfterDate": {
                return Optional.ofNullable(clazz.cast(this.notAfterDate()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedCertificate, T> g) {
        return obj -> g.apply((DescribedCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String certificateId;
        private String usage;
        private String status;
        private String certificate;
        private String certificateChain;
        private Instant activeDate;
        private Instant inactiveDate;
        private String serial;
        private Instant notBeforeDate;
        private Instant notAfterDate;
        private String type;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedCertificate model) {
            this.arn(model.arn);
            this.certificateId(model.certificateId);
            this.usage(model.usage);
            this.status(model.status);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
            this.activeDate(model.activeDate);
            this.inactiveDate(model.inactiveDate);
            this.serial(model.serial);
            this.notBeforeDate(model.notBeforeDate);
            this.notAfterDate(model.notAfterDate);
            this.type(model.type);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getUsage() {
            return this.usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final Instant getActiveDate() {
            return this.activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return this.inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getSerial() {
            return this.serial;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final Instant getNotBeforeDate() {
            return this.notBeforeDate;
        }

        public final void setNotBeforeDate(Instant notBeforeDate) {
            this.notBeforeDate = notBeforeDate;
        }

        @Override
        public final Builder notBeforeDate(Instant notBeforeDate) {
            this.notBeforeDate = notBeforeDate;
            return this;
        }

        public final Instant getNotAfterDate() {
            return this.notAfterDate;
        }

        public final void setNotAfterDate(Instant notAfterDate) {
            this.notAfterDate = notAfterDate;
        }

        @Override
        public final Builder notAfterDate(Instant notAfterDate) {
            this.notAfterDate = notAfterDate;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribedCertificate build() {
            return new DescribedCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedCertificate> {
        public Builder arn(String var1);

        public Builder certificateId(String var1);

        public Builder usage(String var1);

        public Builder usage(CertificateUsageType var1);

        public Builder status(String var1);

        public Builder status(CertificateStatusType var1);

        public Builder certificate(String var1);

        public Builder certificateChain(String var1);

        public Builder activeDate(Instant var1);

        public Builder inactiveDate(Instant var1);

        public Builder serial(String var1);

        public Builder notBeforeDate(Instant var1);

        public Builder notAfterDate(Instant var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

