/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.ExecutionStatus;
import software.amazon.awssdk.services.transfer.model.FileLocation;
import software.amazon.awssdk.services.transfer.model.ServiceMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedExecution> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(ListedExecution.getter(ListedExecution::executionId)).setter(ListedExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<FileLocation> INITIAL_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialFileLocation").getter(ListedExecution.getter(ListedExecution::initialFileLocation)).setter(ListedExecution.setter(Builder::initialFileLocation)).constructor(FileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialFileLocation").build()}).build();
    private static final SdkField<ServiceMetadata> SERVICE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceMetadata").getter(ListedExecution.getter(ListedExecution::serviceMetadata)).setter(ListedExecution.setter(Builder::serviceMetadata)).constructor(ServiceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceMetadata").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListedExecution.getter(ListedExecution::statusAsString)).setter(ListedExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, INITIAL_FILE_LOCATION_FIELD, SERVICE_METADATA_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final FileLocation initialFileLocation;
    private final ServiceMetadata serviceMetadata;
    private final String status;

    private ListedExecution(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.initialFileLocation = builder.initialFileLocation;
        this.serviceMetadata = builder.serviceMetadata;
        this.status = builder.status;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final FileLocation initialFileLocation() {
        return this.initialFileLocation;
    }

    public final ServiceMetadata serviceMetadata() {
        return this.serviceMetadata;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedExecution)) {
            return false;
        }
        ListedExecution other = (ListedExecution)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.initialFileLocation(), other.initialFileLocation()) && Objects.equals(this.serviceMetadata(), other.serviceMetadata()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListedExecution").add("ExecutionId", (Object)this.executionId()).add("InitialFileLocation", (Object)this.initialFileLocation()).add("ServiceMetadata", (Object)this.serviceMetadata()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "InitialFileLocation": {
                return Optional.ofNullable(clazz.cast(this.initialFileLocation()));
            }
            case "ServiceMetadata": {
                return Optional.ofNullable(clazz.cast(this.serviceMetadata()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedExecution, T> g) {
        return obj -> g.apply((ListedExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private FileLocation initialFileLocation;
        private ServiceMetadata serviceMetadata;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedExecution model) {
            this.executionId(model.executionId);
            this.initialFileLocation(model.initialFileLocation);
            this.serviceMetadata(model.serviceMetadata);
            this.status(model.status);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final FileLocation.Builder getInitialFileLocation() {
            return this.initialFileLocation != null ? this.initialFileLocation.toBuilder() : null;
        }

        public final void setInitialFileLocation(FileLocation.BuilderImpl initialFileLocation) {
            this.initialFileLocation = initialFileLocation != null ? initialFileLocation.build() : null;
        }

        @Override
        public final Builder initialFileLocation(FileLocation initialFileLocation) {
            this.initialFileLocation = initialFileLocation;
            return this;
        }

        public final ServiceMetadata.Builder getServiceMetadata() {
            return this.serviceMetadata != null ? this.serviceMetadata.toBuilder() : null;
        }

        public final void setServiceMetadata(ServiceMetadata.BuilderImpl serviceMetadata) {
            this.serviceMetadata = serviceMetadata != null ? serviceMetadata.build() : null;
        }

        @Override
        public final Builder serviceMetadata(ServiceMetadata serviceMetadata) {
            this.serviceMetadata = serviceMetadata;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ListedExecution build() {
            return new ListedExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedExecution> {
        public Builder executionId(String var1);

        public Builder initialFileLocation(FileLocation var1);

        default public Builder initialFileLocation(Consumer<FileLocation.Builder> initialFileLocation) {
            return this.initialFileLocation((FileLocation)((FileLocation.Builder)FileLocation.builder().applyMutation(initialFileLocation)).build());
        }

        public Builder serviceMetadata(ServiceMetadata var1);

        default public Builder serviceMetadata(Consumer<ServiceMetadata.Builder> serviceMetadata) {
            return this.serviceMetadata((ServiceMetadata)((ServiceMetadata.Builder)ServiceMetadata.builder().applyMutation(serviceMetadata)).build());
        }

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);
    }
}

