/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3StorageOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3StorageOptions> {
    private static final SdkField<String> DIRECTORY_LISTING_OPTIMIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryListingOptimization").getter(S3StorageOptions.getter(S3StorageOptions::directoryListingOptimizationAsString)).setter(S3StorageOptions.setter(Builder::directoryListingOptimization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryListingOptimization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_LISTING_OPTIMIZATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryListingOptimization;

    private S3StorageOptions(BuilderImpl builder) {
        this.directoryListingOptimization = builder.directoryListingOptimization;
    }

    public final DirectoryListingOptimization directoryListingOptimization() {
        return DirectoryListingOptimization.fromValue(this.directoryListingOptimization);
    }

    public final String directoryListingOptimizationAsString() {
        return this.directoryListingOptimization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryListingOptimizationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3StorageOptions)) {
            return false;
        }
        S3StorageOptions other = (S3StorageOptions)obj;
        return Objects.equals(this.directoryListingOptimizationAsString(), other.directoryListingOptimizationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3StorageOptions").add("DirectoryListingOptimization", (Object)this.directoryListingOptimizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryListingOptimization": {
                return Optional.ofNullable(clazz.cast(this.directoryListingOptimizationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3StorageOptions, T> g) {
        return obj -> g.apply((S3StorageOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryListingOptimization;

        private BuilderImpl() {
        }

        private BuilderImpl(S3StorageOptions model) {
            this.directoryListingOptimization(model.directoryListingOptimization);
        }

        public final String getDirectoryListingOptimization() {
            return this.directoryListingOptimization;
        }

        public final void setDirectoryListingOptimization(String directoryListingOptimization) {
            this.directoryListingOptimization = directoryListingOptimization;
        }

        @Override
        public final Builder directoryListingOptimization(String directoryListingOptimization) {
            this.directoryListingOptimization = directoryListingOptimization;
            return this;
        }

        @Override
        public final Builder directoryListingOptimization(DirectoryListingOptimization directoryListingOptimization) {
            this.directoryListingOptimization(directoryListingOptimization == null ? null : directoryListingOptimization.toString());
            return this;
        }

        public S3StorageOptions build() {
            return new S3StorageOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3StorageOptions> {
        public Builder directoryListingOptimization(String var1);

        public Builder directoryListingOptimization(DirectoryListingOptimization var1);
    }
}

