/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;
import software.amazon.awssdk.services.transfer.model.ListedServer;

public class ListServersPublisher
implements SdkPublisher<ListServersResponse> {
    private final TransferAsyncClient client;
    private final ListServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServersPublisher(TransferAsyncClient client, ListServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServersPublisher(TransferAsyncClient client, ListServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedServer> servers() {
        Function<ListServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.servers() != null) {
                return response.servers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServersResponseFetcher
    implements AsyncPageFetcher<ListServersResponse> {
        private ListServersResponseFetcher() {
        }

        public boolean hasNextPage(ListServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServersResponse> nextPage(ListServersResponse previousPage) {
            if (previousPage == null) {
                return ListServersPublisher.this.client.listServers(ListServersPublisher.this.firstRequest);
            }
            return ListServersPublisher.this.client.listServers((ListServersRequest)((Object)ListServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

