/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transfer.DefaultTransferBaseClientBuilder;
import software.amazon.awssdk.services.transfer.DefaultTransferClient;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.TransferClientBuilder;
import software.amazon.awssdk.services.transfer.TransferServiceClientConfiguration;
import software.amazon.awssdk.services.transfer.endpoints.TransferEndpointProvider;

@SdkInternalApi
final class DefaultTransferClientBuilder
extends DefaultTransferBaseClientBuilder<TransferClientBuilder, TransferClient>
implements TransferClientBuilder {
    DefaultTransferClientBuilder() {
    }

    @Override
    public DefaultTransferClientBuilder endpointProvider(TransferEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TransferClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTransferClientBuilder.validateClientOptions(clientConfiguration);
        TransferServiceClientConfiguration serviceClientConfiguration = TransferServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultTransferClient(serviceClientConfiguration, clientConfiguration);
    }
}

