/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.ProfileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedProfile.getter(ListedProfile::arn)).setter(ListedProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ListedProfile.getter(ListedProfile::profileId)).setter(ListedProfile.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> AS2_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("As2Id").getter(ListedProfile.getter(ListedProfile::as2Id)).setter(ListedProfile.setter(Builder::as2Id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Id").build()}).build();
    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileType").getter(ListedProfile.getter(ListedProfile::profileTypeAsString)).setter(ListedProfile.setter(Builder::profileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROFILE_ID_FIELD, AS2_ID_FIELD, PROFILE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String profileId;
    private final String as2Id;
    private final String profileType;

    private ListedProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.profileId = builder.profileId;
        this.as2Id = builder.as2Id;
        this.profileType = builder.profileType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String as2Id() {
        return this.as2Id;
    }

    public final ProfileType profileType() {
        return ProfileType.fromValue(this.profileType);
    }

    public final String profileTypeAsString() {
        return this.profileType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.as2Id());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedProfile)) {
            return false;
        }
        ListedProfile other = (ListedProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.as2Id(), other.as2Id()) && Objects.equals(this.profileTypeAsString(), other.profileTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListedProfile").add("Arn", (Object)this.arn()).add("ProfileId", (Object)this.profileId()).add("As2Id", (Object)this.as2Id()).add("ProfileType", (Object)this.profileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "As2Id": {
                return Optional.ofNullable(clazz.cast(this.as2Id()));
            }
            case "ProfileType": {
                return Optional.ofNullable(clazz.cast(this.profileTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedProfile, T> g) {
        return obj -> g.apply((ListedProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String profileId;
        private String as2Id;
        private String profileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedProfile model) {
            this.arn(model.arn);
            this.profileId(model.profileId);
            this.as2Id(model.as2Id);
            this.profileType(model.profileType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getAs2Id() {
            return this.as2Id;
        }

        public final void setAs2Id(String as2Id) {
            this.as2Id = as2Id;
        }

        @Override
        public final Builder as2Id(String as2Id) {
            this.as2Id = as2Id;
            return this;
        }

        public final String getProfileType() {
            return this.profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        public ListedProfile build() {
            return new ListedProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedProfile> {
        public Builder arn(String var1);

        public Builder profileId(String var1);

        public Builder as2Id(String var1);

        public Builder profileType(String var1);

        public Builder profileType(ProfileType var1);
    }
}

