/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.Domain;
import software.amazon.awssdk.services.transfer.model.EndpointDetails;
import software.amazon.awssdk.services.transfer.model.EndpointType;
import software.amazon.awssdk.services.transfer.model.IdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.IdentityProviderType;
import software.amazon.awssdk.services.transfer.model.Protocol;
import software.amazon.awssdk.services.transfer.model.ProtocolDetails;
import software.amazon.awssdk.services.transfer.model.ProtocolsCopier;
import software.amazon.awssdk.services.transfer.model.State;
import software.amazon.awssdk.services.transfer.model.StructuredLogDestinationsCopier;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.WorkflowDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedServer.getter(DescribedServer::arn)).setter(DescribedServer.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(DescribedServer.getter(DescribedServer::certificate)).setter(DescribedServer.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<ProtocolDetails> PROTOCOL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtocolDetails").getter(DescribedServer.getter(DescribedServer::protocolDetails)).setter(DescribedServer.setter(Builder::protocolDetails)).constructor(ProtocolDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolDetails").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribedServer.getter(DescribedServer::domainAsString)).setter(DescribedServer.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointDetails").getter(DescribedServer.getter(DescribedServer::endpointDetails)).setter(DescribedServer.setter(Builder::endpointDetails)).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(DescribedServer.getter(DescribedServer::endpointTypeAsString)).setter(DescribedServer.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> HOST_KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyFingerprint").getter(DescribedServer.getter(DescribedServer::hostKeyFingerprint)).setter(DescribedServer.setter(Builder::hostKeyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyFingerprint").build()}).build();
    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderDetails").getter(DescribedServer.getter(DescribedServer::identityProviderDetails)).setter(DescribedServer.setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderType").getter(DescribedServer.getter(DescribedServer::identityProviderTypeAsString)).setter(DescribedServer.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(DescribedServer.getter(DescribedServer::loggingRole)).setter(DescribedServer.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<String> POST_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAuthenticationLoginBanner").getter(DescribedServer.getter(DescribedServer::postAuthenticationLoginBanner)).setter(DescribedServer.setter(Builder::postAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAuthenticationLoginBanner").build()}).build();
    private static final SdkField<String> PRE_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreAuthenticationLoginBanner").getter(DescribedServer.getter(DescribedServer::preAuthenticationLoginBanner)).setter(DescribedServer.setter(Builder::preAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAuthenticationLoginBanner").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(DescribedServer.getter(DescribedServer::protocolsAsStrings)).setter(DescribedServer.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(DescribedServer.getter(DescribedServer::securityPolicyName)).setter(DescribedServer.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(DescribedServer.getter(DescribedServer::serverId)).setter(DescribedServer.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribedServer.getter(DescribedServer::stateAsString)).setter(DescribedServer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedServer.getter(DescribedServer::tags)).setter(DescribedServer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserCount").getter(DescribedServer.getter(DescribedServer::userCount)).setter(DescribedServer.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()}).build();
    private static final SdkField<WorkflowDetails> WORKFLOW_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkflowDetails").getter(DescribedServer.getter(DescribedServer::workflowDetails)).setter(DescribedServer.setter(Builder::workflowDetails)).constructor(WorkflowDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowDetails").build()}).build();
    private static final SdkField<List<String>> STRUCTURED_LOG_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StructuredLogDestinations").getter(DescribedServer.getter(DescribedServer::structuredLogDestinations)).setter(DescribedServer.setter(Builder::structuredLogDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StructuredLogDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CERTIFICATE_FIELD, PROTOCOL_DETAILS_FIELD, DOMAIN_FIELD, ENDPOINT_DETAILS_FIELD, ENDPOINT_TYPE_FIELD, HOST_KEY_FINGERPRINT_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, LOGGING_ROLE_FIELD, POST_AUTHENTICATION_LOGIN_BANNER_FIELD, PRE_AUTHENTICATION_LOGIN_BANNER_FIELD, PROTOCOLS_FIELD, SECURITY_POLICY_NAME_FIELD, SERVER_ID_FIELD, STATE_FIELD, TAGS_FIELD, USER_COUNT_FIELD, WORKFLOW_DETAILS_FIELD, STRUCTURED_LOG_DESTINATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String certificate;
    private final ProtocolDetails protocolDetails;
    private final String domain;
    private final EndpointDetails endpointDetails;
    private final String endpointType;
    private final String hostKeyFingerprint;
    private final IdentityProviderDetails identityProviderDetails;
    private final String identityProviderType;
    private final String loggingRole;
    private final String postAuthenticationLoginBanner;
    private final String preAuthenticationLoginBanner;
    private final List<String> protocols;
    private final String securityPolicyName;
    private final String serverId;
    private final String state;
    private final List<Tag> tags;
    private final Integer userCount;
    private final WorkflowDetails workflowDetails;
    private final List<String> structuredLogDestinations;

    private DescribedServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificate = builder.certificate;
        this.protocolDetails = builder.protocolDetails;
        this.domain = builder.domain;
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.hostKeyFingerprint = builder.hostKeyFingerprint;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderType = builder.identityProviderType;
        this.loggingRole = builder.loggingRole;
        this.postAuthenticationLoginBanner = builder.postAuthenticationLoginBanner;
        this.preAuthenticationLoginBanner = builder.preAuthenticationLoginBanner;
        this.protocols = builder.protocols;
        this.securityPolicyName = builder.securityPolicyName;
        this.serverId = builder.serverId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.userCount = builder.userCount;
        this.workflowDetails = builder.workflowDetails;
        this.structuredLogDestinations = builder.structuredLogDestinations;
    }

    public final String arn() {
        return this.arn;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final ProtocolDetails protocolDetails() {
        return this.protocolDetails;
    }

    public final Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final EndpointDetails endpointDetails() {
        return this.endpointDetails;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String hostKeyFingerprint() {
        return this.hostKeyFingerprint;
    }

    public final IdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public final String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public final String loggingRole() {
        return this.loggingRole;
    }

    public final String postAuthenticationLoginBanner() {
        return this.postAuthenticationLoginBanner;
    }

    public final String preAuthenticationLoginBanner() {
        return this.preAuthenticationLoginBanner;
    }

    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final WorkflowDetails workflowDetails() {
        return this.workflowDetails;
    }

    public final boolean hasStructuredLogDestinations() {
        return this.structuredLogDestinations != null && !(this.structuredLogDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> structuredLogDestinations() {
        return this.structuredLogDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.preAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStructuredLogDestinations() ? this.structuredLogDestinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedServer)) {
            return false;
        }
        DescribedServer other = (DescribedServer)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.protocolDetails(), other.protocolDetails()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.endpointDetails(), other.endpointDetails()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.hostKeyFingerprint(), other.hostKeyFingerprint()) && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.loggingRole(), other.loggingRole()) && Objects.equals(this.postAuthenticationLoginBanner(), other.postAuthenticationLoginBanner()) && Objects.equals(this.preAuthenticationLoginBanner(), other.preAuthenticationLoginBanner()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.workflowDetails(), other.workflowDetails()) && this.hasStructuredLogDestinations() == other.hasStructuredLogDestinations() && Objects.equals(this.structuredLogDestinations(), other.structuredLogDestinations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedServer").add("Arn", (Object)this.arn()).add("Certificate", (Object)this.certificate()).add("ProtocolDetails", (Object)this.protocolDetails()).add("Domain", (Object)this.domainAsString()).add("EndpointDetails", (Object)this.endpointDetails()).add("EndpointType", (Object)this.endpointTypeAsString()).add("HostKeyFingerprint", (Object)this.hostKeyFingerprint()).add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("LoggingRole", (Object)this.loggingRole()).add("PostAuthenticationLoginBanner", (Object)this.postAuthenticationLoginBanner()).add("PreAuthenticationLoginBanner", (Object)this.preAuthenticationLoginBanner()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("ServerId", (Object)this.serverId()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UserCount", (Object)this.userCount()).add("WorkflowDetails", (Object)this.workflowDetails()).add("StructuredLogDestinations", this.hasStructuredLogDestinations() ? this.structuredLogDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "ProtocolDetails": {
                return Optional.ofNullable(clazz.cast(this.protocolDetails()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "EndpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "HostKeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.hostKeyFingerprint()));
            }
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "PostAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.postAuthenticationLoginBanner()));
            }
            case "PreAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.preAuthenticationLoginBanner()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "WorkflowDetails": {
                return Optional.ofNullable(clazz.cast(this.workflowDetails()));
            }
            case "StructuredLogDestinations": {
                return Optional.ofNullable(clazz.cast(this.structuredLogDestinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedServer, T> g) {
        return obj -> g.apply((DescribedServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String certificate;
        private ProtocolDetails protocolDetails;
        private String domain;
        private EndpointDetails endpointDetails;
        private String endpointType;
        private String hostKeyFingerprint;
        private IdentityProviderDetails identityProviderDetails;
        private String identityProviderType;
        private String loggingRole;
        private String postAuthenticationLoginBanner;
        private String preAuthenticationLoginBanner;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String securityPolicyName;
        private String serverId;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer userCount;
        private WorkflowDetails workflowDetails;
        private List<String> structuredLogDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedServer model) {
            this.arn(model.arn);
            this.certificate(model.certificate);
            this.protocolDetails(model.protocolDetails);
            this.domain(model.domain);
            this.endpointDetails(model.endpointDetails);
            this.endpointType(model.endpointType);
            this.hostKeyFingerprint(model.hostKeyFingerprint);
            this.identityProviderDetails(model.identityProviderDetails);
            this.identityProviderType(model.identityProviderType);
            this.loggingRole(model.loggingRole);
            this.postAuthenticationLoginBanner(model.postAuthenticationLoginBanner);
            this.preAuthenticationLoginBanner(model.preAuthenticationLoginBanner);
            this.protocolsWithStrings(model.protocols);
            this.securityPolicyName(model.securityPolicyName);
            this.serverId(model.serverId);
            this.state(model.state);
            this.tags(model.tags);
            this.userCount(model.userCount);
            this.workflowDetails(model.workflowDetails);
            this.structuredLogDestinations(model.structuredLogDestinations);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final ProtocolDetails.Builder getProtocolDetails() {
            return this.protocolDetails != null ? this.protocolDetails.toBuilder() : null;
        }

        public final void setProtocolDetails(ProtocolDetails.BuilderImpl protocolDetails) {
            this.protocolDetails = protocolDetails != null ? protocolDetails.build() : null;
        }

        @Override
        public final Builder protocolDetails(ProtocolDetails protocolDetails) {
            this.protocolDetails = protocolDetails;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return this.endpointDetails != null ? this.endpointDetails.toBuilder() : null;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getHostKeyFingerprint() {
            return this.hostKeyFingerprint;
        }

        public final void setHostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
        }

        @Override
        public final Builder hostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
            return this;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final String getPostAuthenticationLoginBanner() {
            return this.postAuthenticationLoginBanner;
        }

        public final void setPostAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
        }

        @Override
        public final Builder postAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
            return this;
        }

        public final String getPreAuthenticationLoginBanner() {
            return this.preAuthenticationLoginBanner;
        }

        public final void setPreAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
        }

        @Override
        public final Builder preAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final WorkflowDetails.Builder getWorkflowDetails() {
            return this.workflowDetails != null ? this.workflowDetails.toBuilder() : null;
        }

        public final void setWorkflowDetails(WorkflowDetails.BuilderImpl workflowDetails) {
            this.workflowDetails = workflowDetails != null ? workflowDetails.build() : null;
        }

        @Override
        public final Builder workflowDetails(WorkflowDetails workflowDetails) {
            this.workflowDetails = workflowDetails;
            return this;
        }

        public final Collection<String> getStructuredLogDestinations() {
            if (this.structuredLogDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.structuredLogDestinations;
        }

        public final void setStructuredLogDestinations(Collection<String> structuredLogDestinations) {
            this.structuredLogDestinations = StructuredLogDestinationsCopier.copy(structuredLogDestinations);
        }

        @Override
        public final Builder structuredLogDestinations(Collection<String> structuredLogDestinations) {
            this.structuredLogDestinations = StructuredLogDestinationsCopier.copy(structuredLogDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredLogDestinations(String ... structuredLogDestinations) {
            this.structuredLogDestinations(Arrays.asList(structuredLogDestinations));
            return this;
        }

        public DescribedServer build() {
            return new DescribedServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedServer> {
        public Builder arn(String var1);

        public Builder certificate(String var1);

        public Builder protocolDetails(ProtocolDetails var1);

        default public Builder protocolDetails(Consumer<ProtocolDetails.Builder> protocolDetails) {
            return this.protocolDetails((ProtocolDetails)((ProtocolDetails.Builder)ProtocolDetails.builder().applyMutation(protocolDetails)).build());
        }

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder endpointDetails(EndpointDetails var1);

        default public Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return this.endpointDetails((EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation(endpointDetails)).build());
        }

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder hostKeyFingerprint(String var1);

        public Builder identityProviderDetails(IdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((IdentityProviderDetails)((IdentityProviderDetails.Builder)IdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder loggingRole(String var1);

        public Builder postAuthenticationLoginBanner(String var1);

        public Builder preAuthenticationLoginBanner(String var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder securityPolicyName(String var1);

        public Builder serverId(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder userCount(Integer var1);

        public Builder workflowDetails(WorkflowDetails var1);

        default public Builder workflowDetails(Consumer<WorkflowDetails.Builder> workflowDetails) {
            return this.workflowDetails((WorkflowDetails)((WorkflowDetails.Builder)WorkflowDetails.builder().applyMutation(workflowDetails)).build());
        }

        public Builder structuredLogDestinations(Collection<String> var1);

        public Builder structuredLogDestinations(String ... var1);
    }
}

