/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.ListAgreementsRequest;
import software.amazon.awssdk.services.transfer.model.ListAgreementsResponse;
import software.amazon.awssdk.services.transfer.model.ListedAgreement;

public class ListAgreementsPublisher
implements SdkPublisher<ListAgreementsResponse> {
    private final TransferAsyncClient client;
    private final ListAgreementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgreementsPublisher(TransferAsyncClient client, ListAgreementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgreementsPublisher(TransferAsyncClient client, ListAgreementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgreementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgreementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedAgreement> agreements() {
        Function<ListAgreementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agreements() != null) {
                return response.agreements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgreementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgreementsResponseFetcher
    implements AsyncPageFetcher<ListAgreementsResponse> {
        private ListAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgreementsResponse> nextPage(ListAgreementsResponse previousPage) {
            if (previousPage == null) {
                return ListAgreementsPublisher.this.client.listAgreements(ListAgreementsPublisher.this.firstRequest);
            }
            return ListAgreementsPublisher.this.client.listAgreements((ListAgreementsRequest)((Object)ListAgreementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

