/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.model.AccessDeniedException;
import software.amazon.awssdk.services.transfer.model.ConflictException;
import software.amazon.awssdk.services.transfer.model.CreateAccessRequest;
import software.amazon.awssdk.services.transfer.model.CreateAccessResponse;
import software.amazon.awssdk.services.transfer.model.CreateServerRequest;
import software.amazon.awssdk.services.transfer.model.CreateServerResponse;
import software.amazon.awssdk.services.transfer.model.CreateUserRequest;
import software.amazon.awssdk.services.transfer.model.CreateUserResponse;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DeleteAccessRequest;
import software.amazon.awssdk.services.transfer.model.DeleteAccessResponse;
import software.amazon.awssdk.services.transfer.model.DeleteServerRequest;
import software.amazon.awssdk.services.transfer.model.DeleteServerResponse;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.DeleteUserRequest;
import software.amazon.awssdk.services.transfer.model.DeleteUserResponse;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DescribeAccessRequest;
import software.amazon.awssdk.services.transfer.model.DescribeAccessResponse;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.model.DescribeUserRequest;
import software.amazon.awssdk.services.transfer.model.DescribeUserResponse;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.InternalServiceErrorException;
import software.amazon.awssdk.services.transfer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.transfer.model.InvalidRequestException;
import software.amazon.awssdk.services.transfer.model.ListAccessesRequest;
import software.amazon.awssdk.services.transfer.model.ListAccessesResponse;
import software.amazon.awssdk.services.transfer.model.ListExecutionsRequest;
import software.amazon.awssdk.services.transfer.model.ListExecutionsResponse;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transfer.model.ListUsersRequest;
import software.amazon.awssdk.services.transfer.model.ListUsersResponse;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.transfer.model.ResourceExistsException;
import software.amazon.awssdk.services.transfer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateResponse;
import software.amazon.awssdk.services.transfer.model.ServiceUnavailableException;
import software.amazon.awssdk.services.transfer.model.StartServerRequest;
import software.amazon.awssdk.services.transfer.model.StartServerResponse;
import software.amazon.awssdk.services.transfer.model.StopServerRequest;
import software.amazon.awssdk.services.transfer.model.StopServerResponse;
import software.amazon.awssdk.services.transfer.model.TagResourceRequest;
import software.amazon.awssdk.services.transfer.model.TagResourceResponse;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse;
import software.amazon.awssdk.services.transfer.model.ThrottlingException;
import software.amazon.awssdk.services.transfer.model.TransferException;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceResponse;
import software.amazon.awssdk.services.transfer.model.UpdateAccessRequest;
import software.amazon.awssdk.services.transfer.model.UpdateAccessResponse;
import software.amazon.awssdk.services.transfer.model.UpdateServerRequest;
import software.amazon.awssdk.services.transfer.model.UpdateServerResponse;
import software.amazon.awssdk.services.transfer.model.UpdateUserRequest;
import software.amazon.awssdk.services.transfer.model.UpdateUserResponse;
import software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListServersIterable;
import software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.transfer.paginators.ListUsersIterable;
import software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable;
import software.amazon.awssdk.services.transfer.transform.CreateAccessRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.CreateServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteAccessRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeAccessRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeExecutionRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeSecurityPolicyRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.DescribeWorkflowRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ImportSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListAccessesRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListExecutionsRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListSecurityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListServersRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.SendWorkflowStepStateRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.StartServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.StopServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.TestIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UpdateAccessRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UpdateServerRequestMarshaller;
import software.amazon.awssdk.services.transfer.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTransferClient
implements TransferClient {
    private static final Logger log = Logger.loggerFor(DefaultTransferClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTransferClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "transfer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessResponse createAccess(CreateAccessRequest createAccessRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, createAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccess");
            CreateAccessResponse createAccessResponse = (CreateAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$createAccess$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServerResponse createServer(CreateServerRequest createServerRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, createServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateServer");
            CreateServerResponse createServerResponse = (CreateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$createServer$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$createUser$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, createWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkflow");
            CreateWorkflowResponse createWorkflowResponse = (CreateWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$createWorkflow$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessResponse deleteAccess(DeleteAccessRequest deleteAccessRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccess");
            DeleteAccessResponse deleteAccessResponse = (DeleteAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$deleteAccess$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, deleteServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServer");
            DeleteServerResponse deleteServerResponse = (DeleteServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$deleteServer$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSshPublicKeyResponse deleteSshPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, deleteSshPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSshPublicKey");
            DeleteSshPublicKeyResponse deleteSshPublicKeyResponse = (DeleteSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSshPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSshPublicKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSshPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$deleteSshPublicKey$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$deleteUser$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkflow");
            DeleteWorkflowResponse deleteWorkflowResponse = (DeleteWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$deleteWorkflow$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccessResponse describeAccess(DescribeAccessRequest describeAccessRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccess");
            DescribeAccessResponse describeAccessResponse = (DescribeAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeAccess$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExecution");
            DescribeExecutionResponse describeExecutionResponse = (DescribeExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeExecution$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSecurityPolicyResponse describeSecurityPolicy(DescribeSecurityPolicyRequest describeSecurityPolicyRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSecurityPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeSecurityPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSecurityPolicy");
            DescribeSecurityPolicyResponse describeSecurityPolicyResponse = (DescribeSecurityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSecurityPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSecurityPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSecurityPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSecurityPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeSecurityPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServerResponse describeServer(DescribeServerRequest describeServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServer");
            DescribeServerResponse describeServerResponse = (DescribeServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeServer$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUser");
            DescribeUserResponse describeUserResponse = (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeUser$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkflowResponse describeWorkflow(DescribeWorkflowRequest describeWorkflowRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, describeWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkflow");
            DescribeWorkflowResponse describeWorkflowResponse = (DescribeWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$describeWorkflow$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportSshPublicKeyResponse importSshPublicKey(ImportSshPublicKeyRequest importSshPublicKeyRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, importSshPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportSshPublicKey");
            ImportSshPublicKeyResponse importSshPublicKeyResponse = (ImportSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportSshPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importSshPublicKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importSshPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$importSshPublicKey$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessesResponse listAccesses(ListAccessesRequest listAccessesRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listAccessesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccesses");
            ListAccessesResponse listAccessesResponse = (ListAccessesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccesses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccessesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccessesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccessesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listAccesses$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessesIterable listAccessesPaginator(ListAccessesRequest listAccessesRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return new ListAccessesIterable(this, this.applyPaginatorUserAgent(listAccessesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExecutions");
            ListExecutionsResponse listExecutionsResponse = (ListExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listExecutions$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return new ListExecutionsIterable(this, this.applyPaginatorUserAgent(listExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSecurityPoliciesResponse listSecurityPolicies(ListSecurityPoliciesRequest listSecurityPoliciesRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSecurityPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listSecurityPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSecurityPolicies");
            ListSecurityPoliciesResponse listSecurityPoliciesResponse = (ListSecurityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSecurityPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSecurityPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSecurityPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSecurityPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listSecurityPolicies$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSecurityPoliciesIterable listSecurityPoliciesPaginator(ListSecurityPoliciesRequest listSecurityPoliciesRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListSecurityPoliciesIterable(this, this.applyPaginatorUserAgent(listSecurityPoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServersResponse listServers(ListServersRequest listServersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServers");
            ListServersResponse listServersResponse = (ListServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listServers$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServersIterable listServersPaginator(ListServersRequest listServersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListServersIterable(this, this.applyPaginatorUserAgent(listServersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listTagsForResource$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listUsers$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return new ListUsersIterable(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, listWorkflowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflows");
            ListWorkflowsResponse listWorkflowsResponse = (ListWorkflowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkflowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkflowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkflowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$listWorkflows$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return new ListWorkflowsIterable(this, this.applyPaginatorUserAgent(listWorkflowsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendWorkflowStepStateResponse sendWorkflowStepState(SendWorkflowStepStateRequest sendWorkflowStepStateRequest) throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendWorkflowStepStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, sendWorkflowStepStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendWorkflowStepState");
            SendWorkflowStepStateResponse sendWorkflowStepStateResponse = (SendWorkflowStepStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendWorkflowStepState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendWorkflowStepStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendWorkflowStepStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendWorkflowStepStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$sendWorkflowStepState$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartServerResponse startServer(StartServerRequest startServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, startServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartServer");
            StartServerResponse startServerResponse = (StartServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$startServer$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopServerResponse stopServer(StopServerRequest stopServerRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, stopServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopServer");
            StopServerResponse stopServerResponse = (StopServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$stopServer$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$tagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestIdentityProviderResponse testIdentityProvider(TestIdentityProviderRequest testIdentityProviderRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, testIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestIdentityProvider");
            TestIdentityProviderResponse testIdentityProviderResponse = (TestIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$testIdentityProvider$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccessResponse updateAccess(UpdateAccessRequest updateAccessRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, updateAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccess");
            UpdateAccessResponse updateAccessResponse = (UpdateAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$updateAccess$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws AccessDeniedException, ServiceUnavailableException, ConflictException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, updateServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServer");
            UpdateServerResponse updateServerResponse = (UpdateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$updateServer$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultTransferClient.resolveMetricPublishers(this.clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Transfer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTransferClient.lambda$updateUser$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TransferException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceError").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceExistsException").exceptionBuilderSupplier(ResourceExistsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends TransferRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.82").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TransferRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateUser$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServer$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccess$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testIdentityProvider$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopServer$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startServer$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendWorkflowStepState$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflows$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServers$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSecurityPolicies$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExecutions$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccesses$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importSshPublicKey$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkflow$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUser$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServer$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSecurityPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExecution$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccess$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkflow$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSshPublicKey$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServer$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccess$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkflow$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createServer$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccess$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

