/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.model.ListExecutionsRequest;
import software.amazon.awssdk.services.transfer.model.ListExecutionsResponse;

public class ListExecutionsIterable
implements SdkIterable<ListExecutionsResponse> {
    private final TransferClient client;
    private final ListExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExecutionsIterable(TransferClient client, ListExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExecutionsResponseFetcher();
    }

    public Iterator<ListExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExecutionsResponseFetcher
    implements SyncPageFetcher<ListExecutionsResponse> {
        private ListExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExecutionsResponse nextPage(ListExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListExecutionsIterable.this.client.listExecutions(ListExecutionsIterable.this.firstRequest);
            }
            return ListExecutionsIterable.this.client.listExecutions((ListExecutionsRequest)((Object)ListExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

