/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.Domain;
import software.amazon.awssdk.services.transfer.model.EndpointDetails;
import software.amazon.awssdk.services.transfer.model.EndpointType;
import software.amazon.awssdk.services.transfer.model.IdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.IdentityProviderType;
import software.amazon.awssdk.services.transfer.model.Protocol;
import software.amazon.awssdk.services.transfer.model.ProtocolDetails;
import software.amazon.awssdk.services.transfer.model.ProtocolsCopier;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.model.WorkflowDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServerRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, CreateServerRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(CreateServerRequest.getter(CreateServerRequest::certificate)).setter(CreateServerRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateServerRequest.getter(CreateServerRequest::domainAsString)).setter(CreateServerRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointDetails").getter(CreateServerRequest.getter(CreateServerRequest::endpointDetails)).setter(CreateServerRequest.setter(Builder::endpointDetails)).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(CreateServerRequest.getter(CreateServerRequest::endpointTypeAsString)).setter(CreateServerRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> HOST_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKey").getter(CreateServerRequest.getter(CreateServerRequest::hostKey)).setter(CreateServerRequest.setter(Builder::hostKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()}).build();
    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderDetails").getter(CreateServerRequest.getter(CreateServerRequest::identityProviderDetails)).setter(CreateServerRequest.setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderType").getter(CreateServerRequest.getter(CreateServerRequest::identityProviderTypeAsString)).setter(CreateServerRequest.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(CreateServerRequest.getter(CreateServerRequest::loggingRole)).setter(CreateServerRequest.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<String> POST_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAuthenticationLoginBanner").getter(CreateServerRequest.getter(CreateServerRequest::postAuthenticationLoginBanner)).setter(CreateServerRequest.setter(Builder::postAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAuthenticationLoginBanner").build()}).build();
    private static final SdkField<String> PRE_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreAuthenticationLoginBanner").getter(CreateServerRequest.getter(CreateServerRequest::preAuthenticationLoginBanner)).setter(CreateServerRequest.setter(Builder::preAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAuthenticationLoginBanner").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(CreateServerRequest.getter(CreateServerRequest::protocolsAsStrings)).setter(CreateServerRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProtocolDetails> PROTOCOL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtocolDetails").getter(CreateServerRequest.getter(CreateServerRequest::protocolDetails)).setter(CreateServerRequest.setter(Builder::protocolDetails)).constructor(ProtocolDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolDetails").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(CreateServerRequest.getter(CreateServerRequest::securityPolicyName)).setter(CreateServerRequest.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServerRequest.getter(CreateServerRequest::tags)).setter(CreateServerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WorkflowDetails> WORKFLOW_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkflowDetails").getter(CreateServerRequest.getter(CreateServerRequest::workflowDetails)).setter(CreateServerRequest.setter(Builder::workflowDetails)).constructor(WorkflowDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, DOMAIN_FIELD, ENDPOINT_DETAILS_FIELD, ENDPOINT_TYPE_FIELD, HOST_KEY_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, LOGGING_ROLE_FIELD, POST_AUTHENTICATION_LOGIN_BANNER_FIELD, PRE_AUTHENTICATION_LOGIN_BANNER_FIELD, PROTOCOLS_FIELD, PROTOCOL_DETAILS_FIELD, SECURITY_POLICY_NAME_FIELD, TAGS_FIELD, WORKFLOW_DETAILS_FIELD));
    private final String certificate;
    private final String domain;
    private final EndpointDetails endpointDetails;
    private final String endpointType;
    private final String hostKey;
    private final IdentityProviderDetails identityProviderDetails;
    private final String identityProviderType;
    private final String loggingRole;
    private final String postAuthenticationLoginBanner;
    private final String preAuthenticationLoginBanner;
    private final List<String> protocols;
    private final ProtocolDetails protocolDetails;
    private final String securityPolicyName;
    private final List<Tag> tags;
    private final WorkflowDetails workflowDetails;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.domain = builder.domain;
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.hostKey = builder.hostKey;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderType = builder.identityProviderType;
        this.loggingRole = builder.loggingRole;
        this.postAuthenticationLoginBanner = builder.postAuthenticationLoginBanner;
        this.preAuthenticationLoginBanner = builder.preAuthenticationLoginBanner;
        this.protocols = builder.protocols;
        this.protocolDetails = builder.protocolDetails;
        this.securityPolicyName = builder.securityPolicyName;
        this.tags = builder.tags;
        this.workflowDetails = builder.workflowDetails;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final EndpointDetails endpointDetails() {
        return this.endpointDetails;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String hostKey() {
        return this.hostKey;
    }

    public final IdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public final String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public final String loggingRole() {
        return this.loggingRole;
    }

    public final String postAuthenticationLoginBanner() {
        return this.postAuthenticationLoginBanner;
    }

    public final String preAuthenticationLoginBanner() {
        return this.preAuthenticationLoginBanner;
    }

    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final ProtocolDetails protocolDetails() {
        return this.protocolDetails;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final WorkflowDetails workflowDetails() {
        return this.workflowDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.preAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.endpointDetails(), other.endpointDetails()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.hostKey(), other.hostKey()) && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.loggingRole(), other.loggingRole()) && Objects.equals(this.postAuthenticationLoginBanner(), other.postAuthenticationLoginBanner()) && Objects.equals(this.preAuthenticationLoginBanner(), other.preAuthenticationLoginBanner()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.protocolDetails(), other.protocolDetails()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workflowDetails(), other.workflowDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServerRequest").add("Certificate", (Object)this.certificate()).add("Domain", (Object)this.domainAsString()).add("EndpointDetails", (Object)this.endpointDetails()).add("EndpointType", (Object)this.endpointTypeAsString()).add("HostKey", (Object)(this.hostKey() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("LoggingRole", (Object)this.loggingRole()).add("PostAuthenticationLoginBanner", (Object)this.postAuthenticationLoginBanner()).add("PreAuthenticationLoginBanner", (Object)this.preAuthenticationLoginBanner()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("ProtocolDetails", (Object)this.protocolDetails()).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkflowDetails", (Object)this.workflowDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "EndpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "HostKey": {
                return Optional.ofNullable(clazz.cast(this.hostKey()));
            }
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "PostAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.postAuthenticationLoginBanner()));
            }
            case "PreAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.preAuthenticationLoginBanner()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "ProtocolDetails": {
                return Optional.ofNullable(clazz.cast(this.protocolDetails()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WorkflowDetails": {
                return Optional.ofNullable(clazz.cast(this.workflowDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerRequest, T> g) {
        return obj -> g.apply((CreateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String certificate;
        private String domain;
        private EndpointDetails endpointDetails;
        private String endpointType;
        private String hostKey;
        private IdentityProviderDetails identityProviderDetails;
        private String identityProviderType;
        private String loggingRole;
        private String postAuthenticationLoginBanner;
        private String preAuthenticationLoginBanner;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private ProtocolDetails protocolDetails;
        private String securityPolicyName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private WorkflowDetails workflowDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            super(model);
            this.certificate(model.certificate);
            this.domain(model.domain);
            this.endpointDetails(model.endpointDetails);
            this.endpointType(model.endpointType);
            this.hostKey(model.hostKey);
            this.identityProviderDetails(model.identityProviderDetails);
            this.identityProviderType(model.identityProviderType);
            this.loggingRole(model.loggingRole);
            this.postAuthenticationLoginBanner(model.postAuthenticationLoginBanner);
            this.preAuthenticationLoginBanner(model.preAuthenticationLoginBanner);
            this.protocolsWithStrings(model.protocols);
            this.protocolDetails(model.protocolDetails);
            this.securityPolicyName(model.securityPolicyName);
            this.tags(model.tags);
            this.workflowDetails(model.workflowDetails);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return this.endpointDetails != null ? this.endpointDetails.toBuilder() : null;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getHostKey() {
            return this.hostKey;
        }

        public final void setHostKey(String hostKey) {
            this.hostKey = hostKey;
        }

        @Override
        public final Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final String getPostAuthenticationLoginBanner() {
            return this.postAuthenticationLoginBanner;
        }

        public final void setPostAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
        }

        @Override
        public final Builder postAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
            return this;
        }

        public final String getPreAuthenticationLoginBanner() {
            return this.preAuthenticationLoginBanner;
        }

        public final void setPreAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
        }

        @Override
        public final Builder preAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final ProtocolDetails.Builder getProtocolDetails() {
            return this.protocolDetails != null ? this.protocolDetails.toBuilder() : null;
        }

        public final void setProtocolDetails(ProtocolDetails.BuilderImpl protocolDetails) {
            this.protocolDetails = protocolDetails != null ? protocolDetails.build() : null;
        }

        @Override
        public final Builder protocolDetails(ProtocolDetails protocolDetails) {
            this.protocolDetails = protocolDetails;
            return this;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WorkflowDetails.Builder getWorkflowDetails() {
            return this.workflowDetails != null ? this.workflowDetails.toBuilder() : null;
        }

        public final void setWorkflowDetails(WorkflowDetails.BuilderImpl workflowDetails) {
            this.workflowDetails = workflowDetails != null ? workflowDetails.build() : null;
        }

        @Override
        public final Builder workflowDetails(WorkflowDetails workflowDetails) {
            this.workflowDetails = workflowDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServerRequest> {
        public Builder certificate(String var1);

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder endpointDetails(EndpointDetails var1);

        default public Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return this.endpointDetails((EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation(endpointDetails)).build());
        }

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder hostKey(String var1);

        public Builder identityProviderDetails(IdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((IdentityProviderDetails)((IdentityProviderDetails.Builder)IdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder loggingRole(String var1);

        public Builder postAuthenticationLoginBanner(String var1);

        public Builder preAuthenticationLoginBanner(String var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder protocolDetails(ProtocolDetails var1);

        default public Builder protocolDetails(Consumer<ProtocolDetails.Builder> protocolDetails) {
            return this.protocolDetails((ProtocolDetails)((ProtocolDetails.Builder)ProtocolDetails.builder().applyMutation(protocolDetails)).build());
        }

        public Builder securityPolicyName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder workflowDetails(WorkflowDetails var1);

        default public Builder workflowDetails(Consumer<WorkflowDetails.Builder> workflowDetails) {
            return this.workflowDetails((WorkflowDetails)((WorkflowDetails.Builder)WorkflowDetails.builder().applyMutation(workflowDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

