/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMappingsCopier;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryType;
import software.amazon.awssdk.services.transfer.model.PosixProfile;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccessRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateAccessRequest> {
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectory").getter(UpdateAccessRequest.getter(UpdateAccessRequest::homeDirectory)).setter(UpdateAccessRequest.setter(Builder::homeDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectoryType").getter(UpdateAccessRequest.getter(UpdateAccessRequest::homeDirectoryTypeAsString)).setter(UpdateAccessRequest.setter(Builder::homeDirectoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()}).build();
    private static final SdkField<List<HomeDirectoryMapEntry>> HOME_DIRECTORY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HomeDirectoryMappings").getter(UpdateAccessRequest.getter(UpdateAccessRequest::homeDirectoryMappings)).setter(UpdateAccessRequest.setter(Builder::homeDirectoryMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HomeDirectoryMapEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(UpdateAccessRequest.getter(UpdateAccessRequest::policy)).setter(UpdateAccessRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<PosixProfile> POSIX_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixProfile").getter(UpdateAccessRequest.getter(UpdateAccessRequest::posixProfile)).setter(UpdateAccessRequest.setter(Builder::posixProfile)).constructor(PosixProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixProfile").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateAccessRequest.getter(UpdateAccessRequest::role)).setter(UpdateAccessRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateAccessRequest.getter(UpdateAccessRequest::serverId)).setter(UpdateAccessRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(UpdateAccessRequest.getter(UpdateAccessRequest::externalId)).setter(UpdateAccessRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_DIRECTORY_FIELD, HOME_DIRECTORY_TYPE_FIELD, HOME_DIRECTORY_MAPPINGS_FIELD, POLICY_FIELD, POSIX_PROFILE_FIELD, ROLE_FIELD, SERVER_ID_FIELD, EXTERNAL_ID_FIELD));
    private final String homeDirectory;
    private final String homeDirectoryType;
    private final List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private final String policy;
    private final PosixProfile posixProfile;
    private final String role;
    private final String serverId;
    private final String externalId;

    private UpdateAccessRequest(BuilderImpl builder) {
        super(builder);
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.homeDirectoryMappings = builder.homeDirectoryMappings;
        this.policy = builder.policy;
        this.posixProfile = builder.posixProfile;
        this.role = builder.role;
        this.serverId = builder.serverId;
        this.externalId = builder.externalId;
    }

    public final String homeDirectory() {
        return this.homeDirectory;
    }

    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(this.homeDirectoryType);
    }

    public final String homeDirectoryTypeAsString() {
        return this.homeDirectoryType;
    }

    public final boolean hasHomeDirectoryMappings() {
        return this.homeDirectoryMappings != null && !(this.homeDirectoryMappings instanceof SdkAutoConstructList);
    }

    public final List<HomeDirectoryMapEntry> homeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public final String policy() {
        return this.policy;
    }

    public final PosixProfile posixProfile() {
        return this.posixProfile;
    }

    public final String role() {
        return this.role;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String externalId() {
        return this.externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHomeDirectoryMappings() ? this.homeDirectoryMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessRequest)) {
            return false;
        }
        UpdateAccessRequest other = (UpdateAccessRequest)((Object)obj);
        return Objects.equals(this.homeDirectory(), other.homeDirectory()) && Objects.equals(this.homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString()) && this.hasHomeDirectoryMappings() == other.hasHomeDirectoryMappings() && Objects.equals(this.homeDirectoryMappings(), other.homeDirectoryMappings()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.posixProfile(), other.posixProfile()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccessRequest").add("HomeDirectory", (Object)this.homeDirectory()).add("HomeDirectoryType", (Object)this.homeDirectoryTypeAsString()).add("HomeDirectoryMappings", this.hasHomeDirectoryMappings() ? this.homeDirectoryMappings() : null).add("Policy", (Object)this.policy()).add("PosixProfile", (Object)this.posixProfile()).add("Role", (Object)this.role()).add("ServerId", (Object)this.serverId()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HomeDirectory": {
                return Optional.ofNullable(clazz.cast(this.homeDirectory()));
            }
            case "HomeDirectoryType": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryTypeAsString()));
            }
            case "HomeDirectoryMappings": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryMappings()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "PosixProfile": {
                return Optional.ofNullable(clazz.cast(this.posixProfile()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessRequest, T> g) {
        return obj -> g.apply((UpdateAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String homeDirectory;
        private String homeDirectoryType;
        private List<HomeDirectoryMapEntry> homeDirectoryMappings = DefaultSdkAutoConstructList.getInstance();
        private String policy;
        private PosixProfile posixProfile;
        private String role;
        private String serverId;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessRequest model) {
            super(model);
            this.homeDirectory(model.homeDirectory);
            this.homeDirectoryType(model.homeDirectoryType);
            this.homeDirectoryMappings(model.homeDirectoryMappings);
            this.policy(model.policy);
            this.posixProfile(model.posixProfile);
            this.role(model.role);
            this.serverId(model.serverId);
            this.externalId(model.externalId);
        }

        public final String getHomeDirectory() {
            return this.homeDirectory;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        @Override
        @Transient
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        @Override
        @Transient
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        @Transient
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final List<HomeDirectoryMapEntry.Builder> getHomeDirectoryMappings() {
            List<HomeDirectoryMapEntry.Builder> result = HomeDirectoryMappingsCopier.copyToBuilder(this.homeDirectoryMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry.BuilderImpl> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copyFromBuilder(homeDirectoryMappings);
        }

        @Override
        @Transient
        public final Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copy(homeDirectoryMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder homeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Arrays.asList(homeDirectoryMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Stream.of(homeDirectoryMappings).map(c -> (HomeDirectoryMapEntry)((HomeDirectoryMapEntry.Builder)HomeDirectoryMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final PosixProfile.Builder getPosixProfile() {
            return this.posixProfile != null ? this.posixProfile.toBuilder() : null;
        }

        public final void setPosixProfile(PosixProfile.BuilderImpl posixProfile) {
            this.posixProfile = posixProfile != null ? posixProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder posixProfile(PosixProfile posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        @Transient
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        @Transient
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessRequest build() {
            return new UpdateAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccessRequest> {
        public Builder homeDirectory(String var1);

        public Builder homeDirectoryType(String var1);

        public Builder homeDirectoryType(HomeDirectoryType var1);

        public Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> var1);

        public Builder homeDirectoryMappings(HomeDirectoryMapEntry ... var1);

        public Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... var1);

        public Builder policy(String var1);

        public Builder posixProfile(PosixProfile var1);

        default public Builder posixProfile(Consumer<PosixProfile.Builder> posixProfile) {
            return this.posixProfile((PosixProfile)((PosixProfile.Builder)PosixProfile.builder().applyMutation(posixProfile)).build());
        }

        public Builder role(String var1);

        public Builder serverId(String var1);

        public Builder externalId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

