/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.CopyStepDetails;
import software.amazon.awssdk.services.transfer.model.CustomStepDetails;
import software.amazon.awssdk.services.transfer.model.DeleteStepDetails;
import software.amazon.awssdk.services.transfer.model.TagStepDetails;
import software.amazon.awssdk.services.transfer.model.WorkflowStepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStep> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(WorkflowStep.getter(WorkflowStep::typeAsString)).setter(WorkflowStep.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<CopyStepDetails> COPY_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CopyStepDetails").getter(WorkflowStep.getter(WorkflowStep::copyStepDetails)).setter(WorkflowStep.setter(Builder::copyStepDetails)).constructor(CopyStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStepDetails").build()}).build();
    private static final SdkField<CustomStepDetails> CUSTOM_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomStepDetails").getter(WorkflowStep.getter(WorkflowStep::customStepDetails)).setter(WorkflowStep.setter(Builder::customStepDetails)).constructor(CustomStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomStepDetails").build()}).build();
    private static final SdkField<DeleteStepDetails> DELETE_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeleteStepDetails").getter(WorkflowStep.getter(WorkflowStep::deleteStepDetails)).setter(WorkflowStep.setter(Builder::deleteStepDetails)).constructor(DeleteStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteStepDetails").build()}).build();
    private static final SdkField<TagStepDetails> TAG_STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagStepDetails").getter(WorkflowStep.getter(WorkflowStep::tagStepDetails)).setter(WorkflowStep.setter(Builder::tagStepDetails)).constructor(TagStepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagStepDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, COPY_STEP_DETAILS_FIELD, CUSTOM_STEP_DETAILS_FIELD, DELETE_STEP_DETAILS_FIELD, TAG_STEP_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final CopyStepDetails copyStepDetails;
    private final CustomStepDetails customStepDetails;
    private final DeleteStepDetails deleteStepDetails;
    private final TagStepDetails tagStepDetails;

    private WorkflowStep(BuilderImpl builder) {
        this.type = builder.type;
        this.copyStepDetails = builder.copyStepDetails;
        this.customStepDetails = builder.customStepDetails;
        this.deleteStepDetails = builder.deleteStepDetails;
        this.tagStepDetails = builder.tagStepDetails;
    }

    public final WorkflowStepType type() {
        return WorkflowStepType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CopyStepDetails copyStepDetails() {
        return this.copyStepDetails;
    }

    public final CustomStepDetails customStepDetails() {
        return this.customStepDetails;
    }

    public final DeleteStepDetails deleteStepDetails() {
        return this.deleteStepDetails;
    }

    public final TagStepDetails tagStepDetails() {
        return this.tagStepDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.customStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagStepDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStep)) {
            return false;
        }
        WorkflowStep other = (WorkflowStep)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.copyStepDetails(), other.copyStepDetails()) && Objects.equals(this.customStepDetails(), other.customStepDetails()) && Objects.equals(this.deleteStepDetails(), other.deleteStepDetails()) && Objects.equals(this.tagStepDetails(), other.tagStepDetails());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStep").add("Type", (Object)this.typeAsString()).add("CopyStepDetails", (Object)this.copyStepDetails()).add("CustomStepDetails", (Object)this.customStepDetails()).add("DeleteStepDetails", (Object)this.deleteStepDetails()).add("TagStepDetails", (Object)this.tagStepDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CopyStepDetails": {
                return Optional.ofNullable(clazz.cast(this.copyStepDetails()));
            }
            case "CustomStepDetails": {
                return Optional.ofNullable(clazz.cast(this.customStepDetails()));
            }
            case "DeleteStepDetails": {
                return Optional.ofNullable(clazz.cast(this.deleteStepDetails()));
            }
            case "TagStepDetails": {
                return Optional.ofNullable(clazz.cast(this.tagStepDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStep, T> g) {
        return obj -> g.apply((WorkflowStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private CopyStepDetails copyStepDetails;
        private CustomStepDetails customStepDetails;
        private DeleteStepDetails deleteStepDetails;
        private TagStepDetails tagStepDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStep model) {
            this.type(model.type);
            this.copyStepDetails(model.copyStepDetails);
            this.customStepDetails(model.customStepDetails);
            this.deleteStepDetails(model.deleteStepDetails);
            this.tagStepDetails(model.tagStepDetails);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CopyStepDetails.Builder getCopyStepDetails() {
            return this.copyStepDetails != null ? this.copyStepDetails.toBuilder() : null;
        }

        public final void setCopyStepDetails(CopyStepDetails.BuilderImpl copyStepDetails) {
            this.copyStepDetails = copyStepDetails != null ? copyStepDetails.build() : null;
        }

        @Override
        public final Builder copyStepDetails(CopyStepDetails copyStepDetails) {
            this.copyStepDetails = copyStepDetails;
            return this;
        }

        public final CustomStepDetails.Builder getCustomStepDetails() {
            return this.customStepDetails != null ? this.customStepDetails.toBuilder() : null;
        }

        public final void setCustomStepDetails(CustomStepDetails.BuilderImpl customStepDetails) {
            this.customStepDetails = customStepDetails != null ? customStepDetails.build() : null;
        }

        @Override
        public final Builder customStepDetails(CustomStepDetails customStepDetails) {
            this.customStepDetails = customStepDetails;
            return this;
        }

        public final DeleteStepDetails.Builder getDeleteStepDetails() {
            return this.deleteStepDetails != null ? this.deleteStepDetails.toBuilder() : null;
        }

        public final void setDeleteStepDetails(DeleteStepDetails.BuilderImpl deleteStepDetails) {
            this.deleteStepDetails = deleteStepDetails != null ? deleteStepDetails.build() : null;
        }

        @Override
        public final Builder deleteStepDetails(DeleteStepDetails deleteStepDetails) {
            this.deleteStepDetails = deleteStepDetails;
            return this;
        }

        public final TagStepDetails.Builder getTagStepDetails() {
            return this.tagStepDetails != null ? this.tagStepDetails.toBuilder() : null;
        }

        public final void setTagStepDetails(TagStepDetails.BuilderImpl tagStepDetails) {
            this.tagStepDetails = tagStepDetails != null ? tagStepDetails.build() : null;
        }

        @Override
        public final Builder tagStepDetails(TagStepDetails tagStepDetails) {
            this.tagStepDetails = tagStepDetails;
            return this;
        }

        public WorkflowStep build() {
            return new WorkflowStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStep> {
        public Builder type(String var1);

        public Builder type(WorkflowStepType var1);

        public Builder copyStepDetails(CopyStepDetails var1);

        default public Builder copyStepDetails(Consumer<CopyStepDetails.Builder> copyStepDetails) {
            return this.copyStepDetails((CopyStepDetails)((CopyStepDetails.Builder)CopyStepDetails.builder().applyMutation(copyStepDetails)).build());
        }

        public Builder customStepDetails(CustomStepDetails var1);

        default public Builder customStepDetails(Consumer<CustomStepDetails.Builder> customStepDetails) {
            return this.customStepDetails((CustomStepDetails)((CustomStepDetails.Builder)CustomStepDetails.builder().applyMutation(customStepDetails)).build());
        }

        public Builder deleteStepDetails(DeleteStepDetails var1);

        default public Builder deleteStepDetails(Consumer<DeleteStepDetails.Builder> deleteStepDetails) {
            return this.deleteStepDetails((DeleteStepDetails)((DeleteStepDetails.Builder)DeleteStepDetails.builder().applyMutation(deleteStepDetails)).build());
        }

        public Builder tagStepDetails(TagStepDetails var1);

        default public Builder tagStepDetails(Consumer<TagStepDetails.Builder> tagStepDetails) {
            return this.tagStepDetails((TagStepDetails)((TagStepDetails.Builder)TagStepDetails.builder().applyMutation(tagStepDetails)).build());
        }
    }
}

