/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.EndpointType;
import software.amazon.awssdk.services.transfer.model.IdentityProviderType;
import software.amazon.awssdk.services.transfer.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedServer.getter(ListedServer::arn)).setter(ListedServer.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderType").getter(ListedServer.getter(ListedServer::identityProviderTypeAsString)).setter(ListedServer.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ListedServer.getter(ListedServer::endpointTypeAsString)).setter(ListedServer.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(ListedServer.getter(ListedServer::loggingRole)).setter(ListedServer.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(ListedServer.getter(ListedServer::serverId)).setter(ListedServer.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListedServer.getter(ListedServer::stateAsString)).setter(ListedServer.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserCount").getter(ListedServer.getter(ListedServer::userCount)).setter(ListedServer.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, ENDPOINT_TYPE_FIELD, LOGGING_ROLE_FIELD, SERVER_ID_FIELD, STATE_FIELD, USER_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String identityProviderType;
    private final String endpointType;
    private final String loggingRole;
    private final String serverId;
    private final String state;
    private final Integer userCount;

    private ListedServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.identityProviderType = builder.identityProviderType;
        this.endpointType = builder.endpointType;
        this.loggingRole = builder.loggingRole;
        this.serverId = builder.serverId;
        this.state = builder.state;
        this.userCount = builder.userCount;
    }

    public String arn() {
        return this.arn;
    }

    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String loggingRole() {
        return this.loggingRole;
    }

    public String serverId() {
        return this.serverId;
    }

    public State state() {
        return State.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Integer userCount() {
        return this.userCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedServer)) {
            return false;
        }
        ListedServer other = (ListedServer)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.loggingRole(), other.loggingRole()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userCount(), other.userCount());
    }

    public String toString() {
        return ToString.builder((String)"ListedServer").add("Arn", (Object)this.arn()).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("EndpointType", (Object)this.endpointTypeAsString()).add("LoggingRole", (Object)this.loggingRole()).add("ServerId", (Object)this.serverId()).add("State", (Object)this.stateAsString()).add("UserCount", (Object)this.userCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UserCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedServer, T> g) {
        return obj -> g.apply((ListedServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String identityProviderType;
        private String endpointType;
        private String loggingRole;
        private String serverId;
        private String state;
        private Integer userCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedServer model) {
            this.arn(model.arn);
            this.identityProviderType(model.identityProviderType);
            this.endpointType(model.endpointType);
            this.loggingRole(model.loggingRole);
            this.serverId(model.serverId);
            this.state(model.state);
            this.userCount(model.userCount);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        public ListedServer build() {
            return new ListedServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedServer> {
        public Builder arn(String var1);

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder loggingRole(String var1);

        public Builder serverId(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder userCount(Integer var1);
    }
}

