/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProviderDetails> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(IdentityProviderDetails.getter(IdentityProviderDetails::url)).setter(IdentityProviderDetails.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationRole").getter(IdentityProviderDetails.getter(IdentityProviderDetails::invocationRole)).setter(IdentityProviderDetails.setter(Builder::invocationRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, INVOCATION_ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String invocationRole;

    private IdentityProviderDetails(BuilderImpl builder) {
        this.url = builder.url;
        this.invocationRole = builder.invocationRole;
    }

    public String url() {
        return this.url;
    }

    public String invocationRole() {
        return this.invocationRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderDetails)) {
            return false;
        }
        IdentityProviderDetails other = (IdentityProviderDetails)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.invocationRole(), other.invocationRole());
    }

    public String toString() {
        return ToString.builder((String)"IdentityProviderDetails").add("Url", (Object)this.url()).add("InvocationRole", (Object)this.invocationRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "InvocationRole": {
                return Optional.ofNullable(clazz.cast(this.invocationRole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderDetails, T> g) {
        return obj -> g.apply((IdentityProviderDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String invocationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderDetails model) {
            this.url(model.url);
            this.invocationRole(model.invocationRole);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInvocationRole() {
            return this.invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        public IdentityProviderDetails build() {
            return new IdentityProviderDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProviderDetails> {
        public Builder url(String var1);

        public Builder invocationRole(String var1);
    }
}

