/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyNamesCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityPoliciesResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListSecurityPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSecurityPoliciesResponse.getter(ListSecurityPoliciesResponse::nextToken)).setter(ListSecurityPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> SECURITY_POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSecurityPoliciesResponse.getter(ListSecurityPoliciesResponse::securityPolicyNames)).setter(ListSecurityPoliciesResponse.setter(Builder::securityPolicyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SECURITY_POLICY_NAMES_FIELD));
    private final String nextToken;
    private final List<String> securityPolicyNames;

    private ListSecurityPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.securityPolicyNames = builder.securityPolicyNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSecurityPolicyNames() {
        return this.securityPolicyNames != null && !(this.securityPolicyNames instanceof SdkAutoConstructList);
    }

    public List<String> securityPolicyNames() {
        return this.securityPolicyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityPoliciesResponse)) {
            return false;
        }
        ListSecurityPoliciesResponse other = (ListSecurityPoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.securityPolicyNames(), other.securityPolicyNames());
    }

    public String toString() {
        return ToString.builder((String)"ListSecurityPoliciesResponse").add("NextToken", (Object)this.nextToken()).add("SecurityPolicyNames", this.securityPolicyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SecurityPolicyNames": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityPoliciesResponse, T> g) {
        return obj -> g.apply((ListSecurityPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> securityPolicyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityPoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.securityPolicyNames(model.securityPolicyNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getSecurityPolicyNames() {
            return this.securityPolicyNames;
        }

        @Override
        public final Builder securityPolicyNames(Collection<String> securityPolicyNames) {
            this.securityPolicyNames = SecurityPolicyNamesCopier.copy(securityPolicyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityPolicyNames(String ... securityPolicyNames) {
            this.securityPolicyNames(Arrays.asList(securityPolicyNames));
            return this;
        }

        public final void setSecurityPolicyNames(Collection<String> securityPolicyNames) {
            this.securityPolicyNames = SecurityPolicyNamesCopier.copy(securityPolicyNames);
        }

        @Override
        public ListSecurityPoliciesResponse build() {
            return new ListSecurityPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityPoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder securityPolicyNames(Collection<String> var1);

        public Builder securityPolicyNames(String ... var1);
    }
}

