/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MediaFormat;
import software.amazon.awssdk.services.transcribe.model.MedicalTranscript;
import software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting;
import software.amazon.awssdk.services.transcribe.model.Specialty;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.services.transcribe.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalTranscriptionJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalTranscriptionJob> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalTranscriptionJobName").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::medicalTranscriptionJobName)).setter(MedicalTranscriptionJob.setter(Builder::medicalTranscriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName").build()}).build();
    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobStatus").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::transcriptionJobStatusAsString)).setter(MedicalTranscriptionJob.setter(Builder::transcriptionJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::languageCodeAsString)).setter(MedicalTranscriptionJob.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::mediaSampleRateHertz)).setter(MedicalTranscriptionJob.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFormat").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::mediaFormatAsString)).setter(MedicalTranscriptionJob.setter(Builder::mediaFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::media)).setter(MedicalTranscriptionJob.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<MedicalTranscript> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transcript").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::transcript)).setter(MedicalTranscriptionJob.setter(Builder::transcript)).constructor(MedicalTranscript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::startTime)).setter(MedicalTranscriptionJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::creationTime)).setter(MedicalTranscriptionJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::completionTime)).setter(MedicalTranscriptionJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::failureReason)).setter(MedicalTranscriptionJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<MedicalTranscriptionSetting> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::settings)).setter(MedicalTranscriptionJob.setter(Builder::settings)).constructor(MedicalTranscriptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<String> SPECIALTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Specialty").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::specialtyAsString)).setter(MedicalTranscriptionJob.setter(Builder::specialty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MedicalTranscriptionJob.getter(MedicalTranscriptionJob::typeAsString)).setter(MedicalTranscriptionJob.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, TRANSCRIPT_FIELD, START_TIME_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, FAILURE_REASON_FIELD, SETTINGS_FIELD, SPECIALTY_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String medicalTranscriptionJobName;
    private final String transcriptionJobStatus;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaFormat;
    private final Media media;
    private final MedicalTranscript transcript;
    private final Instant startTime;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String failureReason;
    private final MedicalTranscriptionSetting settings;
    private final String specialty;
    private final String type;

    private MedicalTranscriptionJob(BuilderImpl builder) {
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.transcript = builder.transcript;
        this.startTime = builder.startTime;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.failureReason = builder.failureReason;
        this.settings = builder.settings;
        this.specialty = builder.specialty;
        this.type = builder.type;
    }

    public final String medicalTranscriptionJobName() {
        return this.medicalTranscriptionJobName;
    }

    public final TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(this.transcriptionJobStatus);
    }

    public final String transcriptionJobStatusAsString() {
        return this.transcriptionJobStatus;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(this.mediaFormat);
    }

    public final String mediaFormatAsString() {
        return this.mediaFormat;
    }

    public final Media media() {
        return this.media;
    }

    public final MedicalTranscript transcript() {
        return this.transcript;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final MedicalTranscriptionSetting settings() {
        return this.settings;
    }

    public final Specialty specialty() {
        return Specialty.fromValue(this.specialty);
    }

    public final String specialtyAsString() {
        return this.specialty;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscriptionJob)) {
            return false;
        }
        MedicalTranscriptionJob other = (MedicalTranscriptionJob)obj;
        return Objects.equals(this.medicalTranscriptionJobName(), other.medicalTranscriptionJobName()) && Objects.equals(this.transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.transcript(), other.transcript()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.specialtyAsString(), other.specialtyAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalTranscriptionJob").add("MedicalTranscriptionJobName", (Object)this.medicalTranscriptionJobName()).add("TranscriptionJobStatus", (Object)this.transcriptionJobStatusAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaFormat", (Object)this.mediaFormatAsString()).add("Media", (Object)this.media()).add("Transcript", (Object)this.transcript()).add("StartTime", (Object)this.startTime()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("FailureReason", (Object)this.failureReason()).add("Settings", (Object)this.settings()).add("Specialty", (Object)this.specialtyAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalTranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalTranscriptionJobName()));
            }
            case "TranscriptionJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobStatusAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaFormat": {
                return Optional.ofNullable(clazz.cast(this.mediaFormatAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Specialty": {
                return Optional.ofNullable(clazz.cast(this.specialtyAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscriptionJob, T> g) {
        return obj -> g.apply((MedicalTranscriptionJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String medicalTranscriptionJobName;
        private String transcriptionJobStatus;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaFormat;
        private Media media;
        private MedicalTranscript transcript;
        private Instant startTime;
        private Instant creationTime;
        private Instant completionTime;
        private String failureReason;
        private MedicalTranscriptionSetting settings;
        private String specialty;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscriptionJob model) {
            this.medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            this.transcriptionJobStatus(model.transcriptionJobStatus);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaFormat(model.mediaFormat);
            this.media(model.media);
            this.transcript(model.transcript);
            this.startTime(model.startTime);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.failureReason(model.failureReason);
            this.settings(model.settings);
            this.specialty(model.specialty);
            this.type(model.type);
        }

        public final String getMedicalTranscriptionJobName() {
            return this.medicalTranscriptionJobName;
        }

        @Override
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        public final String getTranscriptionJobStatus() {
            return this.transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaFormat() {
            return this.mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        public final MedicalTranscript.Builder getTranscript() {
            return this.transcript != null ? this.transcript.toBuilder() : null;
        }

        @Override
        public final Builder transcript(MedicalTranscript transcript) {
            this.transcript = transcript;
            return this;
        }

        public final void setTranscript(MedicalTranscript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final MedicalTranscriptionSetting.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(MedicalTranscriptionSetting settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(MedicalTranscriptionSetting.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getSpecialty() {
            return this.specialty;
        }

        @Override
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public MedicalTranscriptionJob build() {
            return new MedicalTranscriptionJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalTranscriptionJob> {
        public Builder medicalTranscriptionJobName(String var1);

        public Builder transcriptionJobStatus(String var1);

        public Builder transcriptionJobStatus(TranscriptionJobStatus var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaFormat(String var1);

        public Builder mediaFormat(MediaFormat var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder transcript(MedicalTranscript var1);

        default public Builder transcript(Consumer<MedicalTranscript.Builder> transcript) {
            return this.transcript((MedicalTranscript)((MedicalTranscript.Builder)MedicalTranscript.builder().applyMutation(transcript)).build());
        }

        public Builder startTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder settings(MedicalTranscriptionSetting var1);

        default public Builder settings(Consumer<MedicalTranscriptionSetting.Builder> settings) {
            return this.settings((MedicalTranscriptionSetting)((MedicalTranscriptionSetting.Builder)MedicalTranscriptionSetting.builder().applyMutation(settings)).build());
        }

        public Builder specialty(String var1);

        public Builder specialty(Specialty var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

