/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLanguageModelsResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListLanguageModelsResponse.Builder, ListLanguageModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLanguageModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<LanguageModel>> MODELS_FIELD = SdkField
            .<List<LanguageModel>> builder(MarshallingType.LIST)
            .memberName("Models")
            .getter(getter(ListLanguageModelsResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LanguageModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(LanguageModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, MODELS_FIELD));

    private final String nextToken;

    private final List<LanguageModel> models;

    private ListLanguageModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.models = builder.models;
    }

    /**
     * <p>
     * The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults parameter.
     * If there are more language models in the list than the page size, Amazon Transcribe returns the
     * <code>NextPage</code> token. Include the token in the next request to the operation to return the next page of
     * language models.
     * </p>
     * 
     * @return The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults
     *         parameter. If there are more language models in the list than the page size, Amazon Transcribe returns
     *         the <code>NextPage</code> token. Include the token in the next request to the operation to return the
     *         next page of language models.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Models property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing information about custom language models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects containing information about custom language models.
     */
    public final List<LanguageModel> models() {
        return models;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguageModelsResponse)) {
            return false;
        }
        ListLanguageModelsResponse other = (ListLanguageModelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLanguageModelsResponse").add("NextToken", nextToken())
                .add("Models", hasModels() ? models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Models":
            return Optional.ofNullable(clazz.cast(models()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguageModelsResponse, T> g) {
        return obj -> g.apply((ListLanguageModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLanguageModelsResponse> {
        /**
         * <p>
         * The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults
         * parameter. If there are more language models in the list than the page size, Amazon Transcribe returns the
         * <code>NextPage</code> token. Include the token in the next request to the operation to return the next page
         * of language models.
         * </p>
         * 
         * @param nextToken
         *        The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults
         *        parameter. If there are more language models in the list than the page size, Amazon Transcribe returns
         *        the <code>NextPage</code> token. Include the token in the next request to the operation to return the
         *        next page of language models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects containing information about custom language models.
         * </p>
         * 
         * @param models
         *        A list of objects containing information about custom language models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<LanguageModel> models);

        /**
         * <p>
         * A list of objects containing information about custom language models.
         * </p>
         * 
         * @param models
         *        A list of objects containing information about custom language models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(LanguageModel... models);

        /**
         * <p>
         * A list of objects containing information about custom language models.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LanguageModel>.Builder} avoiding the need
         * to create one manually via {@link List<LanguageModel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LanguageModel>.Builder#build()} is called immediately and
         * its result is passed to {@link #models(List<LanguageModel>)}.
         * 
         * @param models
         *        a consumer that will call methods on {@link List<LanguageModel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(List<LanguageModel>)
         */
        Builder models(Consumer<LanguageModel.Builder>... models);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<LanguageModel> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguageModelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            models(model.models);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<LanguageModel.Builder> getModels() {
            if (models instanceof SdkAutoConstructList) {
                return null;
            }
            return models != null ? models.stream().map(LanguageModel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder models(Collection<LanguageModel> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(LanguageModel... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<LanguageModel.Builder>... models) {
            models(Stream.of(models).map(c -> LanguageModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModels(Collection<LanguageModel.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        @Override
        public ListLanguageModelsResponse build() {
            return new ListLanguageModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
