/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVocabularyFilterResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetVocabularyFilterResponse.Builder, GetVocabularyFilterResponse> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(GetVocabularyFilterResponse::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(GetVocabularyFilterResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(GetVocabularyFilterResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DOWNLOAD_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DownloadUri").getter(getter(GetVocabularyFilterResponse::downloadUri))
            .setter(setter(Builder::downloadUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD,
            LANGUAGE_CODE_FIELD, LAST_MODIFIED_TIME_FIELD, DOWNLOAD_URI_FIELD));

    private final String vocabularyFilterName;

    private final String languageCode;

    private final Instant lastModifiedTime;

    private final String downloadUri;

    private GetVocabularyFilterResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.languageCode = builder.languageCode;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.downloadUri = builder.downloadUri;
    }

    /**
     * <p>
     * The name of the vocabulary filter.
     * </p>
     * 
     * @return The name of the vocabulary filter.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The date and time that the contents of the vocabulary filter were updated.
     * </p>
     * 
     * @return The date and time that the contents of the vocabulary filter were updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.
     * </p>
     * 
     * @return The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.
     */
    public final String downloadUri() {
        return downloadUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(downloadUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVocabularyFilterResponse)) {
            return false;
        }
        GetVocabularyFilterResponse other = (GetVocabularyFilterResponse) obj;
        return Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(downloadUri(), other.downloadUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVocabularyFilterResponse").add("VocabularyFilterName", vocabularyFilterName())
                .add("LanguageCode", languageCodeAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("DownloadUri", downloadUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DownloadUri":
            return Optional.ofNullable(clazz.cast(downloadUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVocabularyFilterResponse, T> g) {
        return obj -> g.apply((GetVocabularyFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVocabularyFilterResponse> {
        /**
         * <p>
         * The name of the vocabulary filter.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The language code of the words in the vocabulary filter.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the words in the vocabulary filter.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The date and time that the contents of the vocabulary filter were updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the contents of the vocabulary filter were updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.
         * </p>
         * 
         * @param downloadUri
         *        The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUri(String downloadUri);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String vocabularyFilterName;

        private String languageCode;

        private Instant lastModifiedTime;

        private String downloadUri;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVocabularyFilterResponse model) {
            super(model);
            vocabularyFilterName(model.vocabularyFilterName);
            languageCode(model.languageCode);
            lastModifiedTime(model.lastModifiedTime);
            downloadUri(model.downloadUri);
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDownloadUri() {
            return downloadUri;
        }

        @Override
        public final Builder downloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
            return this;
        }

        public final void setDownloadUri(String downloadUri) {
            this.downloadUri = downloadUri;
        }

        @Override
        public GetVocabularyFilterResponse build() {
            return new GetVocabularyFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
