/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NsState {
    INSTANTIATED("INSTANTIATED"),
    NOT_INSTANTIATED("NOT_INSTANTIATED"),
    UPDATED("UPDATED"),
    IMPAIRED("IMPAIRED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    STOPPED("STOPPED"),
    DELETED("DELETED"),
    INSTANTIATE_IN_PROGRESS("INSTANTIATE_IN_PROGRESS"),
    INTENT_TO_UPDATE_IN_PROGRESS("INTENT_TO_UPDATE_IN_PROGRESS"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    TERMINATE_IN_PROGRESS("TERMINATE_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NsState> VALUE_MAP;
    private final String value;

    private NsState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NsState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NsState> knownValues() {
        EnumSet<NsState> knownValues = EnumSet.allOf(NsState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NsState.class, NsState::toString);
    }
}

