/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageMetadata;
import software.amazon.awssdk.services.tnb.model.OnboardingState;
import software.amazon.awssdk.services.tnb.model.OperationalState;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.services.tnb.model.UsageState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolFunctionPackageResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolFunctionPackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::arn)).setter(GetSolFunctionPackageResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::id)).setter(GetSolFunctionPackageResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<GetSolFunctionPackageMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::metadata)).setter(GetSolFunctionPackageResponse.setter(Builder::metadata)).constructor(GetSolFunctionPackageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> ONBOARDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onboardingState").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::onboardingStateAsString)).setter(GetSolFunctionPackageResponse.setter(Builder::onboardingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onboardingState").build()}).build();
    private static final SdkField<String> OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationalState").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::operationalStateAsString)).setter(GetSolFunctionPackageResponse.setter(Builder::operationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationalState").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::tags)).setter(GetSolFunctionPackageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USAGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageState").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::usageStateAsString)).setter(GetSolFunctionPackageResponse.setter(Builder::usageState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageState").build()}).build();
    private static final SdkField<String> VNF_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfProductName").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::vnfProductName)).setter(GetSolFunctionPackageResponse.setter(Builder::vnfProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProductName").build()}).build();
    private static final SdkField<String> VNF_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfProvider").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::vnfProvider)).setter(GetSolFunctionPackageResponse.setter(Builder::vnfProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfProvider").build()}).build();
    private static final SdkField<String> VNFD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfdId").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::vnfdId)).setter(GetSolFunctionPackageResponse.setter(Builder::vnfdId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdId").build()}).build();
    private static final SdkField<String> VNFD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfdVersion").getter(GetSolFunctionPackageResponse.getter(GetSolFunctionPackageResponse::vnfdVersion)).setter(GetSolFunctionPackageResponse.setter(Builder::vnfdVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfdVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, METADATA_FIELD, ONBOARDING_STATE_FIELD, OPERATIONAL_STATE_FIELD, TAGS_FIELD, USAGE_STATE_FIELD, VNF_PRODUCT_NAME_FIELD, VNF_PROVIDER_FIELD, VNFD_ID_FIELD, VNFD_VERSION_FIELD));
    private final String arn;
    private final String id;
    private final GetSolFunctionPackageMetadata metadata;
    private final String onboardingState;
    private final String operationalState;
    private final Map<String, String> tags;
    private final String usageState;
    private final String vnfProductName;
    private final String vnfProvider;
    private final String vnfdId;
    private final String vnfdVersion;

    private GetSolFunctionPackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.onboardingState = builder.onboardingState;
        this.operationalState = builder.operationalState;
        this.tags = builder.tags;
        this.usageState = builder.usageState;
        this.vnfProductName = builder.vnfProductName;
        this.vnfProvider = builder.vnfProvider;
        this.vnfdId = builder.vnfdId;
        this.vnfdVersion = builder.vnfdVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final GetSolFunctionPackageMetadata metadata() {
        return this.metadata;
    }

    public final OnboardingState onboardingState() {
        return OnboardingState.fromValue(this.onboardingState);
    }

    public final String onboardingStateAsString() {
        return this.onboardingState;
    }

    public final OperationalState operationalState() {
        return OperationalState.fromValue(this.operationalState);
    }

    public final String operationalStateAsString() {
        return this.operationalState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UsageState usageState() {
        return UsageState.fromValue(this.usageState);
    }

    public final String usageStateAsString() {
        return this.usageState;
    }

    public final String vnfProductName() {
        return this.vnfProductName;
    }

    public final String vnfProvider() {
        return this.vnfProvider;
    }

    public final String vnfdId() {
        return this.vnfdId;
    }

    public final String vnfdVersion() {
        return this.vnfdVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.onboardingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationalStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfdId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfdVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageResponse)) {
            return false;
        }
        GetSolFunctionPackageResponse other = (GetSolFunctionPackageResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.onboardingStateAsString(), other.onboardingStateAsString()) && Objects.equals(this.operationalStateAsString(), other.operationalStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.usageStateAsString(), other.usageStateAsString()) && Objects.equals(this.vnfProductName(), other.vnfProductName()) && Objects.equals(this.vnfProvider(), other.vnfProvider()) && Objects.equals(this.vnfdId(), other.vnfdId()) && Objects.equals(this.vnfdVersion(), other.vnfdVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolFunctionPackageResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Metadata", (Object)this.metadata()).add("OnboardingState", (Object)this.onboardingStateAsString()).add("OperationalState", (Object)this.operationalStateAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UsageState", (Object)this.usageStateAsString()).add("VnfProductName", (Object)this.vnfProductName()).add("VnfProvider", (Object)this.vnfProvider()).add("VnfdId", (Object)this.vnfdId()).add("VnfdVersion", (Object)this.vnfdVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "onboardingState": {
                return Optional.ofNullable(clazz.cast(this.onboardingStateAsString()));
            }
            case "operationalState": {
                return Optional.ofNullable(clazz.cast(this.operationalStateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "usageState": {
                return Optional.ofNullable(clazz.cast(this.usageStateAsString()));
            }
            case "vnfProductName": {
                return Optional.ofNullable(clazz.cast(this.vnfProductName()));
            }
            case "vnfProvider": {
                return Optional.ofNullable(clazz.cast(this.vnfProvider()));
            }
            case "vnfdId": {
                return Optional.ofNullable(clazz.cast(this.vnfdId()));
            }
            case "vnfdVersion": {
                return Optional.ofNullable(clazz.cast(this.vnfdVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageResponse, T> g) {
        return obj -> g.apply((GetSolFunctionPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private GetSolFunctionPackageMetadata metadata;
        private String onboardingState;
        private String operationalState;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String usageState;
        private String vnfProductName;
        private String vnfProvider;
        private String vnfdId;
        private String vnfdVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.metadata(model.metadata);
            this.onboardingState(model.onboardingState);
            this.operationalState(model.operationalState);
            this.tags(model.tags);
            this.usageState(model.usageState);
            this.vnfProductName(model.vnfProductName);
            this.vnfProvider(model.vnfProvider);
            this.vnfdId(model.vnfdId);
            this.vnfdVersion(model.vnfdVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolFunctionPackageMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolFunctionPackageMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolFunctionPackageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getOnboardingState() {
            return this.onboardingState;
        }

        public final void setOnboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
        }

        @Override
        public final Builder onboardingState(String onboardingState) {
            this.onboardingState = onboardingState;
            return this;
        }

        @Override
        public final Builder onboardingState(OnboardingState onboardingState) {
            this.onboardingState(onboardingState == null ? null : onboardingState.toString());
            return this;
        }

        public final String getOperationalState() {
            return this.operationalState;
        }

        public final void setOperationalState(String operationalState) {
            this.operationalState = operationalState;
        }

        @Override
        public final Builder operationalState(String operationalState) {
            this.operationalState = operationalState;
            return this;
        }

        @Override
        public final Builder operationalState(OperationalState operationalState) {
            this.operationalState(operationalState == null ? null : operationalState.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsageState() {
            return this.usageState;
        }

        public final void setUsageState(String usageState) {
            this.usageState = usageState;
        }

        @Override
        public final Builder usageState(String usageState) {
            this.usageState = usageState;
            return this;
        }

        @Override
        public final Builder usageState(UsageState usageState) {
            this.usageState(usageState == null ? null : usageState.toString());
            return this;
        }

        public final String getVnfProductName() {
            return this.vnfProductName;
        }

        public final void setVnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
        }

        @Override
        public final Builder vnfProductName(String vnfProductName) {
            this.vnfProductName = vnfProductName;
            return this;
        }

        public final String getVnfProvider() {
            return this.vnfProvider;
        }

        public final void setVnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
        }

        @Override
        public final Builder vnfProvider(String vnfProvider) {
            this.vnfProvider = vnfProvider;
            return this;
        }

        public final String getVnfdId() {
            return this.vnfdId;
        }

        public final void setVnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
        }

        @Override
        public final Builder vnfdId(String vnfdId) {
            this.vnfdId = vnfdId;
            return this;
        }

        public final String getVnfdVersion() {
            return this.vnfdVersion;
        }

        public final void setVnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
        }

        @Override
        public final Builder vnfdVersion(String vnfdVersion) {
            this.vnfdVersion = vnfdVersion;
            return this;
        }

        @Override
        public GetSolFunctionPackageResponse build() {
            return new GetSolFunctionPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolFunctionPackageResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder metadata(GetSolFunctionPackageMetadata var1);

        default public Builder metadata(Consumer<GetSolFunctionPackageMetadata.Builder> metadata) {
            return this.metadata((GetSolFunctionPackageMetadata)((GetSolFunctionPackageMetadata.Builder)GetSolFunctionPackageMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder onboardingState(String var1);

        public Builder onboardingState(OnboardingState var1);

        public Builder operationalState(String var1);

        public Builder operationalState(OperationalState var1);

        public Builder tags(Map<String, String> var1);

        public Builder usageState(String var1);

        public Builder usageState(UsageState var1);

        public Builder vnfProductName(String var1);

        public Builder vnfProvider(String var1);

        public Builder vnfdId(String var1);

        public Builder vnfdVersion(String var1);
    }
}

