/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstanceInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse;

public class ListSolNetworkInstancesIterable
implements SdkIterable<ListSolNetworkInstancesResponse> {
    private final TnbClient client;
    private final ListSolNetworkInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolNetworkInstancesIterable(TnbClient client, ListSolNetworkInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSolNetworkInstancesResponseFetcher();
    }

    public Iterator<ListSolNetworkInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSolNetworkInstanceInfo> networkInstances() {
        Function<ListSolNetworkInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInstances() != null) {
                return response.networkInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolNetworkInstancesResponseFetcher
    implements SyncPageFetcher<ListSolNetworkInstancesResponse> {
        private ListSolNetworkInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolNetworkInstancesResponse nextPage(ListSolNetworkInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkInstancesIterable.this.client.listSolNetworkInstances(ListSolNetworkInstancesIterable.this.firstRequest);
            }
            return ListSolNetworkInstancesIterable.this.client.listSolNetworkInstances((ListSolNetworkInstancesRequest)((Object)ListSolNetworkInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

