/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MixedMeasureMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<MixedMeasureMapping.Builder, MixedMeasureMapping> {
    private static final SdkField<String> MEASURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureName").getter(getter(MixedMeasureMapping::measureName)).setter(setter(Builder::measureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureName").build()).build();

    private static final SdkField<String> SOURCE_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceColumn").getter(getter(MixedMeasureMapping::sourceColumn)).setter(setter(Builder::sourceColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumn").build()).build();

    private static final SdkField<String> TARGET_MEASURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetMeasureName").getter(getter(MixedMeasureMapping::targetMeasureName))
            .setter(setter(Builder::targetMeasureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMeasureName").build()).build();

    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValueType").getter(getter(MixedMeasureMapping::measureValueTypeAsString))
            .setter(setter(Builder::measureValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()).build();

    private static final SdkField<List<MultiMeasureAttributeMapping>> MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD = SdkField
            .<List<MultiMeasureAttributeMapping>> builder(MarshallingType.LIST)
            .memberName("MultiMeasureAttributeMappings")
            .getter(getter(MixedMeasureMapping::multiMeasureAttributeMappings))
            .setter(setter(Builder::multiMeasureAttributeMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeMappings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiMeasureAttributeMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiMeasureAttributeMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_NAME_FIELD,
            SOURCE_COLUMN_FIELD, TARGET_MEASURE_NAME_FIELD, MEASURE_VALUE_TYPE_FIELD, MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String measureName;

    private final String sourceColumn;

    private final String targetMeasureName;

    private final String measureValueType;

    private final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings;

    private MixedMeasureMapping(BuilderImpl builder) {
        this.measureName = builder.measureName;
        this.sourceColumn = builder.sourceColumn;
        this.targetMeasureName = builder.targetMeasureName;
        this.measureValueType = builder.measureValueType;
        this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String measureName() {
        return measureName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String sourceColumn() {
        return sourceColumn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String targetMeasureName() {
        return targetMeasureName;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return
     * @see MeasureValueType
     */
    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(measureValueType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link MeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return
     * @see MeasureValueType
     */
    public final String measureValueTypeAsString() {
        return measureValueType;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiMeasureAttributeMappings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMultiMeasureAttributeMappings() {
        return multiMeasureAttributeMappings != null && !(multiMeasureAttributeMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiMeasureAttributeMappings} method.
     * </p>
     * 
     * @return
     */
    public final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings() {
        return multiMeasureAttributeMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(measureName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceColumn());
        hashCode = 31 * hashCode + Objects.hashCode(targetMeasureName());
        hashCode = 31 * hashCode + Objects.hashCode(measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiMeasureAttributeMappings() ? multiMeasureAttributeMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MixedMeasureMapping)) {
            return false;
        }
        MixedMeasureMapping other = (MixedMeasureMapping) obj;
        return Objects.equals(measureName(), other.measureName()) && Objects.equals(sourceColumn(), other.sourceColumn())
                && Objects.equals(targetMeasureName(), other.targetMeasureName())
                && Objects.equals(measureValueTypeAsString(), other.measureValueTypeAsString())
                && hasMultiMeasureAttributeMappings() == other.hasMultiMeasureAttributeMappings()
                && Objects.equals(multiMeasureAttributeMappings(), other.multiMeasureAttributeMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MixedMeasureMapping")
                .add("MeasureName", measureName())
                .add("SourceColumn", sourceColumn())
                .add("TargetMeasureName", targetMeasureName())
                .add("MeasureValueType", measureValueTypeAsString())
                .add("MultiMeasureAttributeMappings", hasMultiMeasureAttributeMappings() ? multiMeasureAttributeMappings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeasureName":
            return Optional.ofNullable(clazz.cast(measureName()));
        case "SourceColumn":
            return Optional.ofNullable(clazz.cast(sourceColumn()));
        case "TargetMeasureName":
            return Optional.ofNullable(clazz.cast(targetMeasureName()));
        case "MeasureValueType":
            return Optional.ofNullable(clazz.cast(measureValueTypeAsString()));
        case "MultiMeasureAttributeMappings":
            return Optional.ofNullable(clazz.cast(multiMeasureAttributeMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MeasureName", MEASURE_NAME_FIELD);
        map.put("SourceColumn", SOURCE_COLUMN_FIELD);
        map.put("TargetMeasureName", TARGET_MEASURE_NAME_FIELD);
        map.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
        map.put("MultiMeasureAttributeMappings", MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MixedMeasureMapping, T> g) {
        return obj -> g.apply((MixedMeasureMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MixedMeasureMapping> {
        /**
         * <p/>
         * 
         * @param measureName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureName(String measureName);

        /**
         * <p/>
         * 
         * @param sourceColumn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceColumn(String sourceColumn);

        /**
         * <p/>
         * 
         * @param targetMeasureName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMeasureName(String targetMeasureName);

        /**
         * <p/>
         * 
         * @param measureValueType
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(String measureValueType);

        /**
         * <p/>
         * 
         * @param measureValueType
         * @see MeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasureValueType
         */
        Builder measureValueType(MeasureValueType measureValueType);

        /**
         * <p/>
         * 
         * @param multiMeasureAttributeMappings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings);

        /**
         * <p/>
         * 
         * @param multiMeasureAttributeMappings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping... multiMeasureAttributeMappings);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #multiMeasureAttributeMappings(List<MultiMeasureAttributeMapping>)}.
         * 
         * @param multiMeasureAttributeMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiMeasureAttributeMappings(java.util.Collection<MultiMeasureAttributeMapping>)
         */
        Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder>... multiMeasureAttributeMappings);
    }

    static final class BuilderImpl implements Builder {
        private String measureName;

        private String sourceColumn;

        private String targetMeasureName;

        private String measureValueType;

        private List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MixedMeasureMapping model) {
            measureName(model.measureName);
            sourceColumn(model.sourceColumn);
            targetMeasureName(model.targetMeasureName);
            measureValueType(model.measureValueType);
            multiMeasureAttributeMappings(model.multiMeasureAttributeMappings);
        }

        public final String getMeasureName() {
            return measureName;
        }

        public final void setMeasureName(String measureName) {
            this.measureName = measureName;
        }

        @Override
        public final Builder measureName(String measureName) {
            this.measureName = measureName;
            return this;
        }

        public final String getSourceColumn() {
            return sourceColumn;
        }

        public final void setSourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        @Override
        public final Builder sourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
            return this;
        }

        public final String getTargetMeasureName() {
            return targetMeasureName;
        }

        public final void setTargetMeasureName(String targetMeasureName) {
            this.targetMeasureName = targetMeasureName;
        }

        @Override
        public final Builder targetMeasureName(String targetMeasureName) {
            this.targetMeasureName = targetMeasureName;
            return this;
        }

        public final String getMeasureValueType() {
            return measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final List<MultiMeasureAttributeMapping.Builder> getMultiMeasureAttributeMappings() {
            List<MultiMeasureAttributeMapping.Builder> result = MultiMeasureAttributeMappingListCopier
                    .copyToBuilder(this.multiMeasureAttributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureAttributeMappings(
                Collection<MultiMeasureAttributeMapping.BuilderImpl> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier
                    .copyFromBuilder(multiMeasureAttributeMappings);
        }

        @Override
        public final Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copy(multiMeasureAttributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping... multiMeasureAttributeMappings) {
            multiMeasureAttributeMappings(Arrays.asList(multiMeasureAttributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(
                Consumer<MultiMeasureAttributeMapping.Builder>... multiMeasureAttributeMappings) {
            multiMeasureAttributeMappings(Stream.of(multiMeasureAttributeMappings)
                    .map(c -> MultiMeasureAttributeMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MixedMeasureMapping build() {
            return new MixedMeasureMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
