/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyEnforcementLevel;
import software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartitionKey> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PartitionKey.getter(PartitionKey::typeAsString)).setter(PartitionKey.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PartitionKey.getter(PartitionKey::name)).setter(PartitionKey.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ENFORCEMENT_IN_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnforcementInRecord").getter(PartitionKey.getter(PartitionKey::enforcementInRecordAsString)).setter(PartitionKey.setter(Builder::enforcementInRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcementInRecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, ENFORCEMENT_IN_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PartitionKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String enforcementInRecord;

    private PartitionKey(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.enforcementInRecord = builder.enforcementInRecord;
    }

    public final PartitionKeyType type() {
        return PartitionKeyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final PartitionKeyEnforcementLevel enforcementInRecord() {
        return PartitionKeyEnforcementLevel.fromValue(this.enforcementInRecord);
    }

    public final String enforcementInRecordAsString() {
        return this.enforcementInRecord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementInRecordAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionKey)) {
            return false;
        }
        PartitionKey other = (PartitionKey)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.enforcementInRecordAsString(), other.enforcementInRecordAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PartitionKey").add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("EnforcementInRecord", (Object)this.enforcementInRecordAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EnforcementInRecord": {
                return Optional.ofNullable(clazz.cast(this.enforcementInRecordAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EnforcementInRecord", ENFORCEMENT_IN_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartitionKey, T> g) {
        return obj -> g.apply((PartitionKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String enforcementInRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionKey model) {
            this.type(model.type);
            this.name(model.name);
            this.enforcementInRecord(model.enforcementInRecord);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartitionKeyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnforcementInRecord() {
            return this.enforcementInRecord;
        }

        public final void setEnforcementInRecord(String enforcementInRecord) {
            this.enforcementInRecord = enforcementInRecord;
        }

        @Override
        public final Builder enforcementInRecord(String enforcementInRecord) {
            this.enforcementInRecord = enforcementInRecord;
            return this;
        }

        @Override
        public final Builder enforcementInRecord(PartitionKeyEnforcementLevel enforcementInRecord) {
            this.enforcementInRecord(enforcementInRecord == null ? null : enforcementInRecord.toString());
            return this;
        }

        public PartitionKey build() {
            return new PartitionKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartitionKey> {
        public Builder type(String var1);

        public Builder type(PartitionKeyType var1);

        public Builder name(String var1);

        public Builder enforcementInRecord(String var1);

        public Builder enforcementInRecord(PartitionKeyEnforcementLevel var1);
    }
}

