/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBatchLoadTaskRequest
extends TimestreamWriteRequest
implements ToCopyableBuilder<Builder, CreateBatchLoadTaskRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::clientToken)).setter(CreateBatchLoadTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DataModelConfiguration> DATA_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataModelConfiguration").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::dataModelConfiguration)).setter(CreateBatchLoadTaskRequest.setter(Builder::dataModelConfiguration)).constructor(DataModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelConfiguration").build()}).build();
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceConfiguration").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::dataSourceConfiguration)).setter(CreateBatchLoadTaskRequest.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build()}).build();
    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportConfiguration").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::reportConfiguration)).setter(CreateBatchLoadTaskRequest.setter(Builder::reportConfiguration)).constructor(ReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportConfiguration").build()}).build();
    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDatabaseName").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::targetDatabaseName)).setter(CreateBatchLoadTaskRequest.setter(Builder::targetDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build()}).build();
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTableName").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::targetTableName)).setter(CreateBatchLoadTaskRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<Long> RECORD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordVersion").getter(CreateBatchLoadTaskRequest.getter(CreateBatchLoadTaskRequest::recordVersion)).setter(CreateBatchLoadTaskRequest.setter(Builder::recordVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_MODEL_CONFIGURATION_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, REPORT_CONFIGURATION_FIELD, TARGET_DATABASE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, RECORD_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBatchLoadTaskRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final DataModelConfiguration dataModelConfiguration;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final ReportConfiguration reportConfiguration;
    private final String targetDatabaseName;
    private final String targetTableName;
    private final Long recordVersion;

    private CreateBatchLoadTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataModelConfiguration = builder.dataModelConfiguration;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.reportConfiguration = builder.reportConfiguration;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetTableName = builder.targetTableName;
        this.recordVersion = builder.recordVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DataModelConfiguration dataModelConfiguration() {
        return this.dataModelConfiguration;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final ReportConfiguration reportConfiguration() {
        return this.reportConfiguration;
    }

    public final String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public final Long recordVersion() {
        return this.recordVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchLoadTaskRequest)) {
            return false;
        }
        CreateBatchLoadTaskRequest other = (CreateBatchLoadTaskRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataModelConfiguration(), other.dataModelConfiguration()) && Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.reportConfiguration(), other.reportConfiguration()) && Objects.equals(this.targetDatabaseName(), other.targetDatabaseName()) && Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.recordVersion(), other.recordVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBatchLoadTaskRequest").add("ClientToken", (Object)(this.clientToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DataModelConfiguration", (Object)this.dataModelConfiguration()).add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("ReportConfiguration", (Object)this.reportConfiguration()).add("TargetDatabaseName", (Object)this.targetDatabaseName()).add("TargetTableName", (Object)this.targetTableName()).add("RecordVersion", (Object)this.recordVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DataModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataModelConfiguration()));
            }
            case "DataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "ReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reportConfiguration()));
            }
            case "TargetDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "RecordVersion": {
                return Optional.ofNullable(clazz.cast(this.recordVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DataModelConfiguration", DATA_MODEL_CONFIGURATION_FIELD);
        map.put("DataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("ReportConfiguration", REPORT_CONFIGURATION_FIELD);
        map.put("TargetDatabaseName", TARGET_DATABASE_NAME_FIELD);
        map.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        map.put("RecordVersion", RECORD_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchLoadTaskRequest, T> g) {
        return obj -> g.apply((CreateBatchLoadTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamWriteRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private DataModelConfiguration dataModelConfiguration;
        private DataSourceConfiguration dataSourceConfiguration;
        private ReportConfiguration reportConfiguration;
        private String targetDatabaseName;
        private String targetTableName;
        private Long recordVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchLoadTaskRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataModelConfiguration(model.dataModelConfiguration);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.reportConfiguration(model.reportConfiguration);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetTableName(model.targetTableName);
            this.recordVersion(model.recordVersion);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataModelConfiguration.Builder getDataModelConfiguration() {
            return this.dataModelConfiguration != null ? this.dataModelConfiguration.toBuilder() : null;
        }

        public final void setDataModelConfiguration(DataModelConfiguration.BuilderImpl dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration != null ? dataModelConfiguration.build() : null;
        }

        @Override
        public final Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return this.reportConfiguration != null ? this.reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final Long getRecordVersion() {
            return this.recordVersion;
        }

        public final void setRecordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
        }

        @Override
        public final Builder recordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchLoadTaskRequest build() {
            return new CreateBatchLoadTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TimestreamWriteRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBatchLoadTaskRequest> {
        public Builder clientToken(String var1);

        public Builder dataModelConfiguration(DataModelConfiguration var1);

        default public Builder dataModelConfiguration(Consumer<DataModelConfiguration.Builder> dataModelConfiguration) {
            return this.dataModelConfiguration((DataModelConfiguration)((DataModelConfiguration.Builder)DataModelConfiguration.builder().applyMutation(dataModelConfiguration)).build());
        }

        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder reportConfiguration(ReportConfiguration var1);

        default public Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return this.reportConfiguration((ReportConfiguration)((ReportConfiguration.Builder)ReportConfiguration.builder().applyMutation(reportConfiguration)).build());
        }

        public Builder targetDatabaseName(String var1);

        public Builder targetTableName(String var1);

        public Builder recordVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

