/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.timestreamwrite.DefaultTimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.DefaultTimestreamWriteBaseClientBuilder;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClientBuilder;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamwrite.endpoints.TimestreamWriteEndpointProvider;

@SdkInternalApi
final class DefaultTimestreamWriteAsyncClientBuilder
extends DefaultTimestreamWriteBaseClientBuilder<TimestreamWriteAsyncClientBuilder, TimestreamWriteAsyncClient>
implements TimestreamWriteAsyncClientBuilder {
    DefaultTimestreamWriteAsyncClientBuilder() {
    }

    @Override
    public DefaultTimestreamWriteAsyncClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    @Override
    public DefaultTimestreamWriteAsyncClientBuilder endpointProvider(TimestreamWriteEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TimestreamWriteAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTimestreamWriteAsyncClientBuilder.validateClientOptions(clientConfiguration);
        TimestreamWriteServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultTimestreamWriteAsyncClient client = new DefaultTimestreamWriteAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private TimestreamWriteServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return TimestreamWriteServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

