/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a batch load task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchLoadTaskDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchLoadTaskDescription.Builder, BatchLoadTaskDescription> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(BatchLoadTaskDescription::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BatchLoadTaskDescription::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSourceConfiguration")
            .getter(getter(BatchLoadTaskDescription::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build())
            .build();

    private static final SdkField<BatchLoadProgressReport> PROGRESS_REPORT_FIELD = SdkField
            .<BatchLoadProgressReport> builder(MarshallingType.SDK_POJO).memberName("ProgressReport")
            .getter(getter(BatchLoadTaskDescription::progressReport)).setter(setter(Builder::progressReport))
            .constructor(BatchLoadProgressReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressReport").build()).build();

    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField
            .<ReportConfiguration> builder(MarshallingType.SDK_POJO).memberName("ReportConfiguration")
            .getter(getter(BatchLoadTaskDescription::reportConfiguration)).setter(setter(Builder::reportConfiguration))
            .constructor(ReportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportConfiguration").build())
            .build();

    private static final SdkField<DataModelConfiguration> DATA_MODEL_CONFIGURATION_FIELD = SdkField
            .<DataModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataModelConfiguration")
            .getter(getter(BatchLoadTaskDescription::dataModelConfiguration)).setter(setter(Builder::dataModelConfiguration))
            .constructor(DataModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelConfiguration").build())
            .build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDatabaseName").getter(getter(BatchLoadTaskDescription::targetDatabaseName))
            .setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTableName").getter(getter(BatchLoadTaskDescription::targetTableName))
            .setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskStatus").getter(getter(BatchLoadTaskDescription::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()).build();

    private static final SdkField<Long> RECORD_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordVersion").getter(getter(BatchLoadTaskDescription::recordVersion))
            .setter(setter(Builder::recordVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(BatchLoadTaskDescription::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(BatchLoadTaskDescription::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> RESUMABLE_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ResumableUntil").getter(getter(BatchLoadTaskDescription::resumableUntil))
            .setter(setter(Builder::resumableUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumableUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            ERROR_MESSAGE_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, PROGRESS_REPORT_FIELD, REPORT_CONFIGURATION_FIELD,
            DATA_MODEL_CONFIGURATION_FIELD, TARGET_DATABASE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, TASK_STATUS_FIELD,
            RECORD_VERSION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RESUMABLE_UNTIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String errorMessage;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final BatchLoadProgressReport progressReport;

    private final ReportConfiguration reportConfiguration;

    private final DataModelConfiguration dataModelConfiguration;

    private final String targetDatabaseName;

    private final String targetTableName;

    private final String taskStatus;

    private final Long recordVersion;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Instant resumableUntil;

    private BatchLoadTaskDescription(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.errorMessage = builder.errorMessage;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.progressReport = builder.progressReport;
        this.reportConfiguration = builder.reportConfiguration;
        this.dataModelConfiguration = builder.dataModelConfiguration;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetTableName = builder.targetTableName;
        this.taskStatus = builder.taskStatus;
        this.recordVersion = builder.recordVersion;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resumableUntil = builder.resumableUntil;
    }

    /**
     * <p>
     * The ID of the batch load task.
     * </p>
     * 
     * @return The ID of the batch load task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Configuration details about the data source for a batch load task.
     * </p>
     * 
     * @return Configuration details about the data source for a batch load task.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final BatchLoadProgressReport progressReport() {
        return progressReport;
    }

    /**
     * <p>
     * Report configuration for a batch load task. This contains details about where error reports are stored.
     * </p>
     * 
     * @return Report configuration for a batch load task. This contains details about where error reports are stored.
     */
    public final ReportConfiguration reportConfiguration() {
        return reportConfiguration;
    }

    /**
     * <p>
     * Data model configuration for a batch load task. This contains details about where a data model for a batch load
     * task is stored.
     * </p>
     * 
     * @return Data model configuration for a batch load task. This contains details about where a data model for a
     *         batch load task is stored.
     */
    public final DataModelConfiguration dataModelConfiguration() {
        return dataModelConfiguration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final BatchLoadStatus taskStatus() {
        return BatchLoadStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Status of the batch load task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link BatchLoadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Status of the batch load task.
     * @see BatchLoadStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long recordVersion() {
        return recordVersion;
    }

    /**
     * <p>
     * The time when the Timestream batch load task was created.
     * </p>
     * 
     * @return The time when the Timestream batch load task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the Timestream batch load task was last updated.
     * </p>
     * 
     * @return The time when the Timestream batch load task was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * </p>
     * 
     * @return
     */
    public final Instant resumableUntil() {
        return resumableUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(progressReport());
        hashCode = 31 * hashCode + Objects.hashCode(reportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(resumableUntil());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadTaskDescription)) {
            return false;
        }
        BatchLoadTaskDescription other = (BatchLoadTaskDescription) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(progressReport(), other.progressReport())
                && Objects.equals(reportConfiguration(), other.reportConfiguration())
                && Objects.equals(dataModelConfiguration(), other.dataModelConfiguration())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetTableName(), other.targetTableName())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(recordVersion(), other.recordVersion()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(resumableUntil(), other.resumableUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchLoadTaskDescription").add("TaskId", taskId()).add("ErrorMessage", errorMessage())
                .add("DataSourceConfiguration", dataSourceConfiguration()).add("ProgressReport", progressReport())
                .add("ReportConfiguration", reportConfiguration()).add("DataModelConfiguration", dataModelConfiguration())
                .add("TargetDatabaseName", targetDatabaseName()).add("TargetTableName", targetTableName())
                .add("TaskStatus", taskStatusAsString()).add("RecordVersion", recordVersion())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("ResumableUntil", resumableUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "DataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "ProgressReport":
            return Optional.ofNullable(clazz.cast(progressReport()));
        case "ReportConfiguration":
            return Optional.ofNullable(clazz.cast(reportConfiguration()));
        case "DataModelConfiguration":
            return Optional.ofNullable(clazz.cast(dataModelConfiguration()));
        case "TargetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "TaskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "RecordVersion":
            return Optional.ofNullable(clazz.cast(recordVersion()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ResumableUntil":
            return Optional.ofNullable(clazz.cast(resumableUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadTaskDescription, T> g) {
        return obj -> g.apply((BatchLoadTaskDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchLoadTaskDescription> {
        /**
         * <p>
         * The ID of the batch load task.
         * </p>
         * 
         * @param taskId
         *        The ID of the batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p/>
         * 
         * @param errorMessage
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Configuration details about the data source for a batch load task.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        Configuration details about the data source for a batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * Configuration details about the data source for a batch load task.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * <p/>
         * 
         * @param progressReport
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressReport(BatchLoadProgressReport progressReport);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link BatchLoadProgressReport.Builder} avoiding
         * the need to create one manually via {@link BatchLoadProgressReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchLoadProgressReport.Builder#build()} is called immediately
         * and its result is passed to {@link #progressReport(BatchLoadProgressReport)}.
         * 
         * @param progressReport
         *        a consumer that will call methods on {@link BatchLoadProgressReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressReport(BatchLoadProgressReport)
         */
        default Builder progressReport(Consumer<BatchLoadProgressReport.Builder> progressReport) {
            return progressReport(BatchLoadProgressReport.builder().applyMutation(progressReport).build());
        }

        /**
         * <p>
         * Report configuration for a batch load task. This contains details about where error reports are stored.
         * </p>
         * 
         * @param reportConfiguration
         *        Report configuration for a batch load task. This contains details about where error reports are
         *        stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportConfiguration(ReportConfiguration reportConfiguration);

        /**
         * <p>
         * Report configuration for a batch load task. This contains details about where error reports are stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportConfiguration.Builder} avoiding the
         * need to create one manually via {@link ReportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #reportConfiguration(ReportConfiguration)}.
         * 
         * @param reportConfiguration
         *        a consumer that will call methods on {@link ReportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportConfiguration(ReportConfiguration)
         */
        default Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return reportConfiguration(ReportConfiguration.builder().applyMutation(reportConfiguration).build());
        }

        /**
         * <p>
         * Data model configuration for a batch load task. This contains details about where a data model for a batch
         * load task is stored.
         * </p>
         * 
         * @param dataModelConfiguration
         *        Data model configuration for a batch load task. This contains details about where a data model for a
         *        batch load task is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration);

        /**
         * <p>
         * Data model configuration for a batch load task. This contains details about where a data model for a batch
         * load task is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataModelConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataModelConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #dataModelConfiguration(DataModelConfiguration)}.
         * 
         * @param dataModelConfiguration
         *        a consumer that will call methods on {@link DataModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataModelConfiguration(DataModelConfiguration)
         */
        default Builder dataModelConfiguration(Consumer<DataModelConfiguration.Builder> dataModelConfiguration) {
            return dataModelConfiguration(DataModelConfiguration.builder().applyMutation(dataModelConfiguration).build());
        }

        /**
         * <p/>
         * 
         * @param targetDatabaseName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p/>
         * 
         * @param targetTableName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Status of the batch load task.
         * </p>
         * 
         * @param taskStatus
         *        Status of the batch load task.
         * @see BatchLoadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchLoadStatus
         */
        Builder taskStatus(BatchLoadStatus taskStatus);

        /**
         * <p/>
         * 
         * @param recordVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordVersion(Long recordVersion);

        /**
         * <p>
         * The time when the Timestream batch load task was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the Timestream batch load task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the Timestream batch load task was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the Timestream batch load task was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * </p>
         * 
         * @param resumableUntil
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumableUntil(Instant resumableUntil);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String errorMessage;

        private DataSourceConfiguration dataSourceConfiguration;

        private BatchLoadProgressReport progressReport;

        private ReportConfiguration reportConfiguration;

        private DataModelConfiguration dataModelConfiguration;

        private String targetDatabaseName;

        private String targetTableName;

        private String taskStatus;

        private Long recordVersion;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Instant resumableUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadTaskDescription model) {
            taskId(model.taskId);
            errorMessage(model.errorMessage);
            dataSourceConfiguration(model.dataSourceConfiguration);
            progressReport(model.progressReport);
            reportConfiguration(model.reportConfiguration);
            dataModelConfiguration(model.dataModelConfiguration);
            targetDatabaseName(model.targetDatabaseName);
            targetTableName(model.targetTableName);
            taskStatus(model.taskStatus);
            recordVersion(model.recordVersion);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            resumableUntil(model.resumableUntil);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final BatchLoadProgressReport.Builder getProgressReport() {
            return progressReport != null ? progressReport.toBuilder() : null;
        }

        public final void setProgressReport(BatchLoadProgressReport.BuilderImpl progressReport) {
            this.progressReport = progressReport != null ? progressReport.build() : null;
        }

        @Override
        public final Builder progressReport(BatchLoadProgressReport progressReport) {
            this.progressReport = progressReport;
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return reportConfiguration != null ? reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        public final DataModelConfiguration.Builder getDataModelConfiguration() {
            return dataModelConfiguration != null ? dataModelConfiguration.toBuilder() : null;
        }

        public final void setDataModelConfiguration(DataModelConfiguration.BuilderImpl dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration != null ? dataModelConfiguration.build() : null;
        }

        @Override
        public final Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration;
            return this;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(BatchLoadStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final Long getRecordVersion() {
            return recordVersion;
        }

        public final void setRecordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
        }

        @Override
        public final Builder recordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getResumableUntil() {
            return resumableUntil;
        }

        public final void setResumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
        }

        @Override
        public final Builder resumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
            return this;
        }

        @Override
        public BatchLoadTaskDescription build() {
            return new BatchLoadTaskDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
