/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunStatus;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryState;
import software.amazon.awssdk.services.timestreamquery.model.TargetDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledQuery> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ScheduledQuery.getter(ScheduledQuery::arn)).setter(ScheduledQuery.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScheduledQuery.getter(ScheduledQuery::name)).setter(ScheduledQuery.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScheduledQuery.getter(ScheduledQuery::creationTime)).setter(ScheduledQuery.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ScheduledQuery.getter(ScheduledQuery::stateAsString)).setter(ScheduledQuery.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> PREVIOUS_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PreviousInvocationTime").getter(ScheduledQuery.getter(ScheduledQuery::previousInvocationTime)).setter(ScheduledQuery.setter(Builder::previousInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousInvocationTime").build()}).build();
    private static final SdkField<Instant> NEXT_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextInvocationTime").getter(ScheduledQuery.getter(ScheduledQuery::nextInvocationTime)).setter(ScheduledQuery.setter(Builder::nextInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocationTime").build()}).build();
    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration").getter(ScheduledQuery.getter(ScheduledQuery::errorReportConfiguration)).setter(ScheduledQuery.setter(Builder::errorReportConfiguration)).constructor(ErrorReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build()}).build();
    private static final SdkField<TargetDestination> TARGET_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetDestination").getter(ScheduledQuery.getter(ScheduledQuery::targetDestination)).setter(ScheduledQuery.setter(Builder::targetDestination)).constructor(TargetDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDestination").build()}).build();
    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRunStatus").getter(ScheduledQuery.getter(ScheduledQuery::lastRunStatusAsString)).setter(ScheduledQuery.setter(Builder::lastRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CREATION_TIME_FIELD, STATE_FIELD, PREVIOUS_INVOCATION_TIME_FIELD, NEXT_INVOCATION_TIME_FIELD, ERROR_REPORT_CONFIGURATION_FIELD, TARGET_DESTINATION_FIELD, LAST_RUN_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Instant creationTime;
    private final String state;
    private final Instant previousInvocationTime;
    private final Instant nextInvocationTime;
    private final ErrorReportConfiguration errorReportConfiguration;
    private final TargetDestination targetDestination;
    private final String lastRunStatus;

    private ScheduledQuery(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.previousInvocationTime = builder.previousInvocationTime;
        this.nextInvocationTime = builder.nextInvocationTime;
        this.errorReportConfiguration = builder.errorReportConfiguration;
        this.targetDestination = builder.targetDestination;
        this.lastRunStatus = builder.lastRunStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant previousInvocationTime() {
        return this.previousInvocationTime;
    }

    public final Instant nextInvocationTime() {
        return this.nextInvocationTime;
    }

    public final ErrorReportConfiguration errorReportConfiguration() {
        return this.errorReportConfiguration;
    }

    public final TargetDestination targetDestination() {
        return this.targetDestination;
    }

    public final ScheduledQueryRunStatus lastRunStatus() {
        return ScheduledQueryRunStatus.fromValue(this.lastRunStatus);
    }

    public final String lastRunStatusAsString() {
        return this.lastRunStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQuery)) {
            return false;
        }
        ScheduledQuery other = (ScheduledQuery)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.previousInvocationTime(), other.previousInvocationTime()) && Objects.equals(this.nextInvocationTime(), other.nextInvocationTime()) && Objects.equals(this.errorReportConfiguration(), other.errorReportConfiguration()) && Objects.equals(this.targetDestination(), other.targetDestination()) && Objects.equals(this.lastRunStatusAsString(), other.lastRunStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledQuery").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).add("State", (Object)this.stateAsString()).add("PreviousInvocationTime", (Object)this.previousInvocationTime()).add("NextInvocationTime", (Object)this.nextInvocationTime()).add("ErrorReportConfiguration", (Object)this.errorReportConfiguration()).add("TargetDestination", (Object)this.targetDestination()).add("LastRunStatus", (Object)this.lastRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PreviousInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.previousInvocationTime()));
            }
            case "NextInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.nextInvocationTime()));
            }
            case "ErrorReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.errorReportConfiguration()));
            }
            case "TargetDestination": {
                return Optional.ofNullable(clazz.cast(this.targetDestination()));
            }
            case "LastRunStatus": {
                return Optional.ofNullable(clazz.cast(this.lastRunStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("PreviousInvocationTime", PREVIOUS_INVOCATION_TIME_FIELD);
        map.put("NextInvocationTime", NEXT_INVOCATION_TIME_FIELD);
        map.put("ErrorReportConfiguration", ERROR_REPORT_CONFIGURATION_FIELD);
        map.put("TargetDestination", TARGET_DESTINATION_FIELD);
        map.put("LastRunStatus", LAST_RUN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQuery, T> g) {
        return obj -> g.apply((ScheduledQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant creationTime;
        private String state;
        private Instant previousInvocationTime;
        private Instant nextInvocationTime;
        private ErrorReportConfiguration errorReportConfiguration;
        private TargetDestination targetDestination;
        private String lastRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQuery model) {
            this.arn(model.arn);
            this.name(model.name);
            this.creationTime(model.creationTime);
            this.state(model.state);
            this.previousInvocationTime(model.previousInvocationTime);
            this.nextInvocationTime(model.nextInvocationTime);
            this.errorReportConfiguration(model.errorReportConfiguration);
            this.targetDestination(model.targetDestination);
            this.lastRunStatus(model.lastRunStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getPreviousInvocationTime() {
            return this.previousInvocationTime;
        }

        public final void setPreviousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
        }

        @Override
        public final Builder previousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
            return this;
        }

        public final Instant getNextInvocationTime() {
            return this.nextInvocationTime;
        }

        public final void setNextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
        }

        @Override
        public final Builder nextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return this.errorReportConfiguration != null ? this.errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        public final TargetDestination.Builder getTargetDestination() {
            return this.targetDestination != null ? this.targetDestination.toBuilder() : null;
        }

        public final void setTargetDestination(TargetDestination.BuilderImpl targetDestination) {
            this.targetDestination = targetDestination != null ? targetDestination.build() : null;
        }

        @Override
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        public final String getLastRunStatus() {
            return this.lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(ScheduledQueryRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        public ScheduledQuery build() {
            return new ScheduledQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledQuery> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);

        public Builder state(String var1);

        public Builder state(ScheduledQueryState var1);

        public Builder previousInvocationTime(Instant var1);

        public Builder nextInvocationTime(Instant var1);

        public Builder errorReportConfiguration(ErrorReportConfiguration var1);

        default public Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return this.errorReportConfiguration((ErrorReportConfiguration)((ErrorReportConfiguration.Builder)ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration)).build());
        }

        public Builder targetDestination(TargetDestination var1);

        default public Builder targetDestination(Consumer<TargetDestination.Builder> targetDestination) {
            return this.targetDestination((TargetDestination)((TargetDestination.Builder)TargetDestination.builder().applyMutation(targetDestination)).build());
        }

        public Builder lastRunStatus(String var1);

        public Builder lastRunStatus(ScheduledQueryRunStatus var1);
    }
}

