/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class TimestreamQueryAsyncEndpointDiscoveryCacheLoader
implements EndpointDiscoveryCacheLoader {
    private final TimestreamQueryAsyncClient client;

    TimestreamQueryAsyncEndpointDiscoveryCacheLoader(TimestreamQueryAsyncClient client) {
        this.client = client;
    }

    public static TimestreamQueryAsyncEndpointDiscoveryCacheLoader create(TimestreamQueryAsyncClient client) {
        return new TimestreamQueryAsyncEndpointDiscoveryCacheLoader(client);
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        AwsRequestOverrideConfiguration requestConfig = AwsRequestOverrideConfiguration.from((RequestOverrideConfiguration)endpointDiscoveryRequest.overrideConfiguration().orElse(null));
        return this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsRequest.builder().overrideConfiguration(requestConfig).build())).thenApply(r -> {
            List<Endpoint> endpoints = r.endpoints();
            Validate.notEmpty(endpoints, (String)"Endpoints returned by service for endpoint discovery must not be empty.", (Object[])new Object[0]);
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder().endpoint(this.toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint())).expirationTime(Instant.now().plus((long)endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}

