/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<QueryResponse.Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(QueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QueryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Row>> ROWS_FIELD = SdkField
            .<List<Row>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(QueryResponse::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Row> builder(MarshallingType.SDK_POJO)
                                            .constructor(Row::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ColumnInfo>> COLUMN_INFO_FIELD = SdkField
            .<List<ColumnInfo>> builder(MarshallingType.LIST)
            .memberName("ColumnInfo")
            .getter(getter(QueryResponse::columnInfo))
            .setter(setter(Builder::columnInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueryStatus> QUERY_STATUS_FIELD = SdkField.<QueryStatus> builder(MarshallingType.SDK_POJO)
            .memberName("QueryStatus").getter(getter(QueryResponse::queryStatus)).setter(setter(Builder::queryStatus))
            .constructor(QueryStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            NEXT_TOKEN_FIELD, ROWS_FIELD, COLUMN_INFO_FIELD, QUERY_STATUS_FIELD));

    private final String queryId;

    private final String nextToken;

    private final List<Row> rows;

    private final List<ColumnInfo> columnInfo;

    private final QueryStatus queryStatus;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.nextToken = builder.nextToken;
        this.rows = builder.rows;
        this.columnInfo = builder.columnInfo;
        this.queryStatus = builder.queryStatus;
    }

    /**
     * <p>
     * A unique ID for the given query.
     * </p>
     * 
     * @return A unique ID for the given query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * A pagination token that can be used again on a <code>Query</code> call to get the next set of results.
     * </p>
     * 
     * @return A pagination token that can be used again on a <code>Query</code> call to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Rows property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The result set rows returned by the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The result set rows returned by the query.
     */
    public final List<Row> rows() {
        return rows;
    }

    /**
     * Returns true if the ColumnInfo property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasColumnInfo() {
        return columnInfo != null && !(columnInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column data types of the returned result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasColumnInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The column data types of the returned result set.
     */
    public final List<ColumnInfo> columnInfo() {
        return columnInfo;
    }

    /**
     * <p>
     * Information about the status of the query, including progress and bytes scannned.
     * </p>
     * 
     * @return Information about the status of the query, including progress and bytes scannned.
     */
    public final QueryStatus queryStatus() {
        return queryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnInfo() ? columnInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(nextToken(), other.nextToken())
                && hasRows() == other.hasRows() && Objects.equals(rows(), other.rows())
                && hasColumnInfo() == other.hasColumnInfo() && Objects.equals(columnInfo(), other.columnInfo())
                && Objects.equals(queryStatus(), other.queryStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryResponse").add("QueryId", queryId()).add("NextToken", nextToken())
                .add("Rows", hasRows() ? rows() : null).add("ColumnInfo", hasColumnInfo() ? columnInfo() : null)
                .add("QueryStatus", queryStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "ColumnInfo":
            return Optional.ofNullable(clazz.cast(columnInfo()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryResponse> {
        /**
         * <p>
         * A unique ID for the given query.
         * </p>
         * 
         * @param queryId
         *        A unique ID for the given query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * A pagination token that can be used again on a <code>Query</code> call to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used again on a <code>Query</code> call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The result set rows returned by the query.
         * </p>
         * 
         * @param rows
         *        The result set rows returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<Row> rows);

        /**
         * <p>
         * The result set rows returned by the query.
         * </p>
         * 
         * @param rows
         *        The result set rows returned by the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Row... rows);

        /**
         * <p>
         * The result set rows returned by the query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Row>.Builder} avoiding the need to create
         * one manually via {@link List<Row>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Row>.Builder#build()} is called immediately and its result
         * is passed to {@link #rows(List<Row>)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link List<Row>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(List<Row>)
         */
        Builder rows(Consumer<Row.Builder>... rows);

        /**
         * <p>
         * The column data types of the returned result set.
         * </p>
         * 
         * @param columnInfo
         *        The column data types of the returned result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnInfo(Collection<ColumnInfo> columnInfo);

        /**
         * <p>
         * The column data types of the returned result set.
         * </p>
         * 
         * @param columnInfo
         *        The column data types of the returned result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnInfo(ColumnInfo... columnInfo);

        /**
         * <p>
         * The column data types of the returned result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnInfo>.Builder} avoiding the need to
         * create one manually via {@link List<ColumnInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #columnInfo(List<ColumnInfo>)}.
         * 
         * @param columnInfo
         *        a consumer that will call methods on {@link List<ColumnInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnInfo(List<ColumnInfo>)
         */
        Builder columnInfo(Consumer<ColumnInfo.Builder>... columnInfo);

        /**
         * <p>
         * Information about the status of the query, including progress and bytes scannned.
         * </p>
         * 
         * @param queryStatus
         *        Information about the status of the query, including progress and bytes scannned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatus(QueryStatus queryStatus);

        /**
         * <p>
         * Information about the status of the query, including progress and bytes scannned.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryStatus.Builder} avoiding the need to create
         * one manually via {@link QueryStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #queryStatus(QueryStatus)}.
         * 
         * @param queryStatus
         *        a consumer that will call methods on {@link QueryStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStatus(QueryStatus)
         */
        default Builder queryStatus(Consumer<QueryStatus.Builder> queryStatus) {
            return queryStatus(QueryStatus.builder().applyMutation(queryStatus).build());
        }
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private String queryId;

        private String nextToken;

        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnInfo> columnInfo = DefaultSdkAutoConstructList.getInstance();

        private QueryStatus queryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            queryId(model.queryId);
            nextToken(model.nextToken);
            rows(model.rows);
            columnInfo(model.columnInfo);
            queryStatus(model.queryStatus);
        }

        public final String getQueryId() {
            return queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Row.Builder> getRows() {
            if (rows instanceof SdkAutoConstructList) {
                return null;
            }
            return rows != null ? rows.stream().map(Row::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder>... rows) {
            rows(Stream.of(rows).map(c -> Row.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        public final Collection<ColumnInfo.Builder> getColumnInfo() {
            if (columnInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return columnInfo != null ? columnInfo.stream().map(ColumnInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnInfo(Collection<ColumnInfo> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copy(columnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(ColumnInfo... columnInfo) {
            columnInfo(Arrays.asList(columnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(Consumer<ColumnInfo.Builder>... columnInfo) {
            columnInfo(Stream.of(columnInfo).map(c -> ColumnInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnInfo(Collection<ColumnInfo.BuilderImpl> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copyFromBuilder(columnInfo);
        }

        public final QueryStatus.Builder getQueryStatus() {
            return queryStatus != null ? queryStatus.toBuilder() : null;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        public final void setQueryStatus(QueryStatus.BuilderImpl queryStatus) {
            this.queryStatus = queryStatus != null ? queryStatus.build() : null;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
