/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfo;
import software.amazon.awssdk.services.timestreamquery.model.ColumnInfoListCopier;
import software.amazon.awssdk.services.timestreamquery.model.Row;
import software.amazon.awssdk.services.timestreamquery.model.RowListCopier;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResponse
extends TimestreamQueryResponse
implements ToCopyableBuilder<Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(QueryResponse.getter(QueryResponse::queryId)).setter(QueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QueryResponse.getter(QueryResponse::nextToken)).setter(QueryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rows").getter(QueryResponse.getter(QueryResponse::rows)).setter(QueryResponse.setter(Builder::rows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Row::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnInfo>> COLUMN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnInfo").getter(QueryResponse.getter(QueryResponse::columnInfo)).setter(QueryResponse.setter(Builder::columnInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, NEXT_TOKEN_FIELD, ROWS_FIELD, COLUMN_INFO_FIELD));
    private final String queryId;
    private final String nextToken;
    private final List<Row> rows;
    private final List<ColumnInfo> columnInfo;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.nextToken = builder.nextToken;
        this.rows = builder.rows;
        this.columnInfo = builder.columnInfo;
    }

    public String queryId() {
        return this.queryId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasRows() {
        return this.rows != null && !(this.rows instanceof SdkAutoConstructList);
    }

    public List<Row> rows() {
        return this.rows;
    }

    public boolean hasColumnInfo() {
        return this.columnInfo != null && !(this.columnInfo instanceof SdkAutoConstructList);
    }

    public List<ColumnInfo> columnInfo() {
        return this.columnInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRows() ? this.rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnInfo() ? this.columnInfo() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRows() == other.hasRows() && Objects.equals(this.rows(), other.rows()) && this.hasColumnInfo() == other.hasColumnInfo() && Objects.equals(this.columnInfo(), other.columnInfo());
    }

    public String toString() {
        return ToString.builder((String)"QueryResponse").add("QueryId", (Object)this.queryId()).add("NextToken", (Object)this.nextToken()).add("Rows", this.hasRows() ? this.rows() : null).add("ColumnInfo", this.hasColumnInfo() ? this.columnInfo() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Rows": {
                return Optional.ofNullable(clazz.cast(this.rows()));
            }
            case "ColumnInfo": {
                return Optional.ofNullable(clazz.cast(this.columnInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private String nextToken;
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnInfo> columnInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.nextToken(model.nextToken);
            this.rows(model.rows);
            this.columnInfo(model.columnInfo);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Row.Builder> getRows() {
            if (this.rows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rows != null ? (Collection)this.rows.stream().map(Row::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row ... rows) {
            this.rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder> ... rows) {
            this.rows(Stream.of(rows).map(c -> (Row)((Row.Builder)Row.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowListCopier.copyFromBuilder(rows);
        }

        public final Collection<ColumnInfo.Builder> getColumnInfo() {
            if (this.columnInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnInfo != null ? (Collection)this.columnInfo.stream().map(ColumnInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnInfo(Collection<ColumnInfo> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copy(columnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(ColumnInfo ... columnInfo) {
            this.columnInfo(Arrays.asList(columnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnInfo(Consumer<ColumnInfo.Builder> ... columnInfo) {
            this.columnInfo(Stream.of(columnInfo).map(c -> (ColumnInfo)((ColumnInfo.Builder)ColumnInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnInfo(Collection<ColumnInfo.BuilderImpl> columnInfo) {
            this.columnInfo = ColumnInfoListCopier.copyFromBuilder(columnInfo);
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryResponse> {
        public Builder queryId(String var1);

        public Builder nextToken(String var1);

        public Builder rows(Collection<Row> var1);

        public Builder rows(Row ... var1);

        public Builder rows(Consumer<Row.Builder> ... var1);

        public Builder columnInfo(Collection<ColumnInfo> var1);

        public Builder columnInfo(ColumnInfo ... var1);

        public Builder columnInfo(Consumer<ColumnInfo.Builder> ... var1);
    }
}

