/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRequest
extends TimestreamQueryRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::queryString)).setter(QueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::clientToken)).setter(QueryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryRequest.getter(QueryRequest::nextToken)).setter(QueryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(QueryRequest.getter(QueryRequest::maxRows)).setter(QueryRequest.setter(Builder::maxRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD, CLIENT_TOKEN_FIELD, NEXT_TOKEN_FIELD, MAX_ROWS_FIELD));
    private final String queryString;
    private final String clientToken;
    private final String nextToken;
    private final Integer maxRows;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.clientToken = builder.clientToken;
        this.nextToken = builder.nextToken;
        this.maxRows = builder.maxRows;
    }

    public String queryString() {
        return this.queryString;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRows() {
        return this.maxRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRows(), other.maxRows());
    }

    public String toString() {
        return ToString.builder((String)"QueryRequest").add("QueryString", (Object)(this.queryString() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)(this.clientToken() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).add("MaxRows", (Object)this.maxRows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRows": {
                return Optional.ofNullable(clazz.cast(this.maxRows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryRequest.BuilderImpl
    implements Builder {
        private String queryString;
        private String clientToken;
        private String nextToken;
        private Integer maxRows;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            this.queryString(model.queryString);
            this.clientToken(model.clientToken);
            this.nextToken(model.nextToken);
            this.maxRows(model.maxRows);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRows() {
            return this.maxRows;
        }

        @Override
        public final Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public final void setMaxRows(Integer maxRows) {
            this.maxRows = maxRows;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryRequest> {
        public Builder queryString(String var1);

        public Builder clientToken(String var1);

        public Builder nextToken(String var1);

        public Builder maxRows(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

