/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Prediction;
import software.amazon.awssdk.services.textract.model.PredictionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PageClassification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PageClassification> {
    private static final SdkField<List<Prediction>> PAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PageType").getter(PageClassification.getter(PageClassification::pageType)).setter(PageClassification.setter(Builder::pageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Prediction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Prediction>> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PageNumber").getter(PageClassification.getter(PageClassification::pageNumber)).setter(PageClassification.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Prediction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_TYPE_FIELD, PAGE_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PageClassification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Prediction> pageType;
    private final List<Prediction> pageNumber;

    private PageClassification(BuilderImpl builder) {
        this.pageType = builder.pageType;
        this.pageNumber = builder.pageNumber;
    }

    public final boolean hasPageType() {
        return this.pageType != null && !(this.pageType instanceof SdkAutoConstructList);
    }

    public final List<Prediction> pageType() {
        return this.pageType;
    }

    public final boolean hasPageNumber() {
        return this.pageNumber != null && !(this.pageNumber instanceof SdkAutoConstructList);
    }

    public final List<Prediction> pageNumber() {
        return this.pageNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPageType() ? this.pageType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPageNumber() ? this.pageNumber() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PageClassification)) {
            return false;
        }
        PageClassification other = (PageClassification)obj;
        return this.hasPageType() == other.hasPageType() && Objects.equals(this.pageType(), other.pageType()) && this.hasPageNumber() == other.hasPageNumber() && Objects.equals(this.pageNumber(), other.pageNumber());
    }

    public final String toString() {
        return ToString.builder((String)"PageClassification").add("PageType", this.hasPageType() ? this.pageType() : null).add("PageNumber", this.hasPageNumber() ? this.pageNumber() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PageType": {
                return Optional.ofNullable(clazz.cast(this.pageType()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Prediction>>> map = new HashMap<String, SdkField<List<Prediction>>>();
        map.put("PageType", PAGE_TYPE_FIELD);
        map.put("PageNumber", PAGE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PageClassification, T> g) {
        return obj -> g.apply((PageClassification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Prediction> pageType = DefaultSdkAutoConstructList.getInstance();
        private List<Prediction> pageNumber = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PageClassification model) {
            this.pageType(model.pageType);
            this.pageNumber(model.pageNumber);
        }

        public final List<Prediction.Builder> getPageType() {
            List<Prediction.Builder> result = PredictionListCopier.copyToBuilder(this.pageType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageType(Collection<Prediction.BuilderImpl> pageType) {
            this.pageType = PredictionListCopier.copyFromBuilder(pageType);
        }

        @Override
        public final Builder pageType(Collection<Prediction> pageType) {
            this.pageType = PredictionListCopier.copy(pageType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageType(Prediction ... pageType) {
            this.pageType(Arrays.asList(pageType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageType(Consumer<Prediction.Builder> ... pageType) {
            this.pageType(Stream.of(pageType).map(c -> (Prediction)((Prediction.Builder)Prediction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Prediction.Builder> getPageNumber() {
            List<Prediction.Builder> result = PredictionListCopier.copyToBuilder(this.pageNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageNumber(Collection<Prediction.BuilderImpl> pageNumber) {
            this.pageNumber = PredictionListCopier.copyFromBuilder(pageNumber);
        }

        @Override
        public final Builder pageNumber(Collection<Prediction> pageNumber) {
            this.pageNumber = PredictionListCopier.copy(pageNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageNumber(Prediction ... pageNumber) {
            this.pageNumber(Arrays.asList(pageNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageNumber(Consumer<Prediction.Builder> ... pageNumber) {
            this.pageNumber(Stream.of(pageNumber).map(c -> (Prediction)((Prediction.Builder)Prediction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PageClassification build() {
            return new PageClassification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PageClassification> {
        public Builder pageType(Collection<Prediction> var1);

        public Builder pageType(Prediction ... var1);

        public Builder pageType(Consumer<Prediction.Builder> ... var1);

        public Builder pageNumber(Collection<Prediction> var1);

        public Builder pageNumber(Prediction ... var1);

        public Builder pageNumber(Consumer<Prediction.Builder> ... var1);
    }
}

