/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An adapter selected for use when analyzing documents. Contains an adapter ID and a version number. Contains
 * information on pages selected for analysis when analyzing documents asychronously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Adapter implements SdkPojo, Serializable, ToCopyableBuilder<Adapter.Builder, Adapter> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(Adapter::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<List<String>> PAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Pages")
            .getter(getter(Adapter::pages))
            .setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(Adapter::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, PAGES_FIELD,
            VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adapterId;

    private final List<String> pages;

    private final String version;

    private Adapter(BuilderImpl builder) {
        this.adapterId = builder.adapterId;
        this.pages = builder.pages;
        this.version = builder.version;
    }

    /**
     * <p>
     * A unique identifier for the adapter resource.
     * </p>
     * 
     * @return A unique identifier for the adapter resource.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pages property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPages() {
        return pages != null && !(pages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is a list
     * of rules for using this parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If a page is not specified, it is set to <code>["1"]</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>. No
     * whitespace is allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * When using * to indicate all pages, it must be the only element in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates last page
     * of document.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPages} method.
     * </p>
     * 
     * @return Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is
     *         a list of rules for using this parameter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If a page is not specified, it is set to <code>["1"]</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>. No
     *         whitespace is allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When using * to indicate all pages, it must be the only element in the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates
     *         last page of document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
     *         </p>
     *         </li>
     */
    public final List<String> pages() {
        return pages;
    }

    /**
     * <p>
     * A string that identifies the version of the adapter.
     * </p>
     * 
     * @return A string that identifies the version of the adapter.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPages() ? pages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter) obj;
        return Objects.equals(adapterId(), other.adapterId()) && hasPages() == other.hasPages()
                && Objects.equals(pages(), other.pages()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Adapter").add("AdapterId", adapterId()).add("Pages", hasPages() ? pages() : null)
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "Pages":
            return Optional.ofNullable(clazz.cast(pages()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("Pages", PAGES_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Adapter, T> g) {
        return obj -> g.apply((Adapter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Adapter> {
        /**
         * <p>
         * A unique identifier for the adapter resource.
         * </p>
         * 
         * @param adapterId
         *        A unique identifier for the adapter resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is a
         * list of rules for using this parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If a page is not specified, it is set to <code>["1"]</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>. No
         * whitespace is allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * When using * to indicate all pages, it must be the only element in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates last
         * page of document.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pages
         *        Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following
         *        is a list of rules for using this parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If a page is not specified, it is set to <code>["1"]</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>.
         *        No whitespace is allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When using * to indicate all pages, it must be the only element in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates
         *        last page of document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Collection<String> pages);

        /**
         * <p>
         * Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is a
         * list of rules for using this parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If a page is not specified, it is set to <code>["1"]</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>. No
         * whitespace is allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * When using * to indicate all pages, it must be the only element in the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates last
         * page of document.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pages
         *        Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following
         *        is a list of rules for using this parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If a page is not specified, it is set to <code>["1"]</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The following characters are allowed in the parameter's string: <code>0 1 2 3 4 5 6 7 8 9 - *</code>.
         *        No whitespace is allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When using * to indicate all pages, it must be the only element in the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can use page intervals, such as <code>["1-3", "1-1", "4-*"]</code>. Where <code>*</code> indicates
         *        last page of document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(String... pages);

        /**
         * <p>
         * A string that identifies the version of the adapter.
         * </p>
         * 
         * @param version
         *        A string that identifies the version of the adapter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String adapterId;

        private List<String> pages = DefaultSdkAutoConstructList.getInstance();

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(Adapter model) {
            adapterId(model.adapterId);
            pages(model.pages);
            version(model.version);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final Collection<String> getPages() {
            if (pages instanceof SdkAutoConstructList) {
                return null;
            }
            return pages;
        }

        public final void setPages(Collection<String> pages) {
            this.pages = AdapterPagesCopier.copy(pages);
        }

        @Override
        public final Builder pages(Collection<String> pages) {
            this.pages = AdapterPagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(String... pages) {
            pages(Arrays.asList(pages));
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Adapter build() {
            return new Adapter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
