/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.QueriesCopier;
import software.amazon.awssdk.services.textract.model.Query;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueriesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueriesConfig> {
    private static final SdkField<List<Query>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queries").getter(QueriesConfig.getter(QueriesConfig::queries)).setter(QueriesConfig.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Query::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueriesConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Query> queries;

    private QueriesConfig(BuilderImpl builder) {
        this.queries = builder.queries;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<Query> queries() {
        return this.queries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueriesConfig)) {
            return false;
        }
        QueriesConfig other = (QueriesConfig)obj;
        return this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries());
    }

    public final String toString() {
        return ToString.builder((String)"QueriesConfig").add("Queries", this.hasQueries() ? this.queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Query>>> map = new HashMap<String, SdkField<List<Query>>>();
        map.put("Queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueriesConfig, T> g) {
        return obj -> g.apply((QueriesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Query> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueriesConfig model) {
            this.queries(model.queries);
        }

        public final List<Query.Builder> getQueries() {
            List<Query.Builder> result = QueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<Query.BuilderImpl> queries) {
            this.queries = QueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<Query> queries) {
            this.queries = QueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Query ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<Query.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (Query)((Query.Builder)Query.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public QueriesConfig build() {
            return new QueriesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueriesConfig> {
        public Builder queries(Collection<Query> var1);

        public Builder queries(Query ... var1);

        public Builder queries(Consumer<Query.Builder> ... var1);
    }
}

