/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAdapterVersionRequest extends TextractRequest implements
        ToCopyableBuilder<CreateAdapterVersionRequest.Builder, CreateAdapterVersionRequest> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdapterId").getter(getter(CreateAdapterVersionRequest::adapterId)).setter(setter(Builder::adapterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateAdapterVersionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AdapterVersionDatasetConfig> DATASET_CONFIG_FIELD = SdkField
            .<AdapterVersionDatasetConfig> builder(MarshallingType.SDK_POJO).memberName("DatasetConfig")
            .getter(getter(CreateAdapterVersionRequest::datasetConfig)).setter(setter(Builder::datasetConfig))
            .constructor(AdapterVersionDatasetConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(CreateAdapterVersionRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CreateAdapterVersionRequest::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAdapterVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, DATASET_CONFIG_FIELD, KMS_KEY_ID_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String adapterId;

    private final String clientRequestToken;

    private final AdapterVersionDatasetConfig datasetConfig;

    private final String kmsKeyId;

    private final OutputConfig outputConfig;

    private final Map<String, String> tags;

    private CreateAdapterVersionRequest(BuilderImpl builder) {
        super(builder);
        this.adapterId = builder.adapterId;
        this.clientRequestToken = builder.clientRequestToken;
        this.datasetConfig = builder.datasetConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A string containing a unique ID for the adapter that will receive a new version.
     * </p>
     * 
     * @return A string containing a unique ID for the adapter that will receive a new version.
     */
    public final String adapterId() {
        return adapterId;
    }

    /**
     * <p>
     * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapterVersion
     * requests, the same session is returned. This token is employed to avoid unintentionally creating the same session
     * multiple times.
     * </p>
     * 
     * @return Idempotent token is used to recognize the request. If the same token is used with multiple
     *         CreateAdapterVersion requests, the same session is returned. This token is employed to avoid
     *         unintentionally creating the same session multiple times.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
     * </p>
     * 
     * @return Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
     */
    public final AdapterVersionDatasetConfig datasetConfig() {
        return datasetConfig;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns the value of the OutputConfig property for this object.
     * 
     * @return The value of the OutputConfig property for this object.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the adapter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the adapter version.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(datasetConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdapterVersionRequest)) {
            return false;
        }
        CreateAdapterVersionRequest other = (CreateAdapterVersionRequest) obj;
        return Objects.equals(adapterId(), other.adapterId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(datasetConfig(), other.datasetConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(outputConfig(), other.outputConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAdapterVersionRequest").add("AdapterId", adapterId())
                .add("ClientRequestToken", clientRequestToken()).add("DatasetConfig", datasetConfig())
                .add("KMSKeyId", kmsKeyId()).add("OutputConfig", outputConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdapterId":
            return Optional.ofNullable(clazz.cast(adapterId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "DatasetConfig":
            return Optional.ofNullable(clazz.cast(datasetConfig()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdapterId", ADAPTER_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DatasetConfig", DATASET_CONFIG_FIELD);
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAdapterVersionRequest, T> g) {
        return obj -> g.apply((CreateAdapterVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAdapterVersionRequest> {
        /**
         * <p>
         * A string containing a unique ID for the adapter that will receive a new version.
         * </p>
         * 
         * @param adapterId
         *        A string containing a unique ID for the adapter that will receive a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adapterId(String adapterId);

        /**
         * <p>
         * Idempotent token is used to recognize the request. If the same token is used with multiple
         * CreateAdapterVersion requests, the same session is returned. This token is employed to avoid unintentionally
         * creating the same session multiple times.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token is used to recognize the request. If the same token is used with multiple
         *        CreateAdapterVersion requests, the same session is returned. This token is employed to avoid
         *        unintentionally creating the same session multiple times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
         * </p>
         * 
         * @param datasetConfig
         *        Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig);

        /**
         * <p>
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdapterVersionDatasetConfig.Builder}
         * avoiding the need to create one manually via {@link AdapterVersionDatasetConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdapterVersionDatasetConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetConfig(AdapterVersionDatasetConfig)}.
         * 
         * @param datasetConfig
         *        a consumer that will call methods on {@link AdapterVersionDatasetConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetConfig(AdapterVersionDatasetConfig)
         */
        default Builder datasetConfig(Consumer<AdapterVersionDatasetConfig.Builder> datasetConfig) {
            return datasetConfig(AdapterVersionDatasetConfig.builder().applyMutation(datasetConfig).build());
        }

        /**
         * <p>
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * @param outputConfig
         *        The new value for the OutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * Sets the value of the OutputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the adapter version.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the adapter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private String adapterId;

        private String clientRequestToken;

        private AdapterVersionDatasetConfig datasetConfig;

        private String kmsKeyId;

        private OutputConfig outputConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdapterVersionRequest model) {
            super(model);
            adapterId(model.adapterId);
            clientRequestToken(model.clientRequestToken);
            datasetConfig(model.datasetConfig);
            kmsKeyId(model.kmsKeyId);
            outputConfig(model.outputConfig);
            tags(model.tags);
        }

        public final String getAdapterId() {
            return adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final AdapterVersionDatasetConfig.Builder getDatasetConfig() {
            return datasetConfig != null ? datasetConfig.toBuilder() : null;
        }

        public final void setDatasetConfig(AdapterVersionDatasetConfig.BuilderImpl datasetConfig) {
            this.datasetConfig = datasetConfig != null ? datasetConfig.build() : null;
        }

        @Override
        public final Builder datasetConfig(AdapterVersionDatasetConfig datasetConfig) {
            this.datasetConfig = datasetConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdapterVersionRequest build() {
            return new CreateAdapterVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
