/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.LendingField;
import software.amazon.awssdk.services.textract.model.LendingFieldListCopier;
import software.amazon.awssdk.services.textract.model.SignatureDetection;
import software.amazon.awssdk.services.textract.model.SignatureDetectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LendingDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LendingDocument> {
    private static final SdkField<List<LendingField>> LENDING_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LendingFields").getter(LendingDocument.getter(LendingDocument::lendingFields)).setter(LendingDocument.setter(Builder::lendingFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LendingFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LendingField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SignatureDetection>> SIGNATURE_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SignatureDetections").getter(LendingDocument.getter(LendingDocument::signatureDetections)).setter(LendingDocument.setter(Builder::signatureDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureDetections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignatureDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENDING_FIELDS_FIELD, SIGNATURE_DETECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LendingFields", LENDING_FIELDS_FIELD);
            this.put("SignatureDetections", SIGNATURE_DETECTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<LendingField> lendingFields;
    private final List<SignatureDetection> signatureDetections;

    private LendingDocument(BuilderImpl builder) {
        this.lendingFields = builder.lendingFields;
        this.signatureDetections = builder.signatureDetections;
    }

    public final boolean hasLendingFields() {
        return this.lendingFields != null && !(this.lendingFields instanceof SdkAutoConstructList);
    }

    public final List<LendingField> lendingFields() {
        return this.lendingFields;
    }

    public final boolean hasSignatureDetections() {
        return this.signatureDetections != null && !(this.signatureDetections instanceof SdkAutoConstructList);
    }

    public final List<SignatureDetection> signatureDetections() {
        return this.signatureDetections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLendingFields() ? this.lendingFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignatureDetections() ? this.signatureDetections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDocument)) {
            return false;
        }
        LendingDocument other = (LendingDocument)obj;
        return this.hasLendingFields() == other.hasLendingFields() && Objects.equals(this.lendingFields(), other.lendingFields()) && this.hasSignatureDetections() == other.hasSignatureDetections() && Objects.equals(this.signatureDetections(), other.signatureDetections());
    }

    public final String toString() {
        return ToString.builder((String)"LendingDocument").add("LendingFields", this.hasLendingFields() ? this.lendingFields() : null).add("SignatureDetections", this.hasSignatureDetections() ? this.signatureDetections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LendingFields": {
                return Optional.ofNullable(clazz.cast(this.lendingFields()));
            }
            case "SignatureDetections": {
                return Optional.ofNullable(clazz.cast(this.signatureDetections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LendingDocument, T> g) {
        return obj -> g.apply((LendingDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LendingField> lendingFields = DefaultSdkAutoConstructList.getInstance();
        private List<SignatureDetection> signatureDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingDocument model) {
            this.lendingFields(model.lendingFields);
            this.signatureDetections(model.signatureDetections);
        }

        public final List<LendingField.Builder> getLendingFields() {
            List<LendingField.Builder> result = LendingFieldListCopier.copyToBuilder(this.lendingFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLendingFields(Collection<LendingField.BuilderImpl> lendingFields) {
            this.lendingFields = LendingFieldListCopier.copyFromBuilder(lendingFields);
        }

        @Override
        public final Builder lendingFields(Collection<LendingField> lendingFields) {
            this.lendingFields = LendingFieldListCopier.copy(lendingFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lendingFields(LendingField ... lendingFields) {
            this.lendingFields(Arrays.asList(lendingFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lendingFields(Consumer<LendingField.Builder> ... lendingFields) {
            this.lendingFields(Stream.of(lendingFields).map(c -> (LendingField)((LendingField.Builder)LendingField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SignatureDetection.Builder> getSignatureDetections() {
            List<SignatureDetection.Builder> result = SignatureDetectionListCopier.copyToBuilder(this.signatureDetections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignatureDetections(Collection<SignatureDetection.BuilderImpl> signatureDetections) {
            this.signatureDetections = SignatureDetectionListCopier.copyFromBuilder(signatureDetections);
        }

        @Override
        public final Builder signatureDetections(Collection<SignatureDetection> signatureDetections) {
            this.signatureDetections = SignatureDetectionListCopier.copy(signatureDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signatureDetections(SignatureDetection ... signatureDetections) {
            this.signatureDetections(Arrays.asList(signatureDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signatureDetections(Consumer<SignatureDetection.Builder> ... signatureDetections) {
            this.signatureDetections(Stream.of(signatureDetections).map(c -> (SignatureDetection)((SignatureDetection.Builder)SignatureDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LendingDocument build() {
            return new LendingDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LendingDocument> {
        public Builder lendingFields(Collection<LendingField> var1);

        public Builder lendingFields(LendingField ... var1);

        public Builder lendingFields(Consumer<LendingField.Builder> ... var1);

        public Builder signatureDetections(Collection<SignatureDetection> var1);

        public Builder signatureDetections(SignatureDetection ... var1);

        public Builder signatureDetections(Consumer<SignatureDetection.Builder> ... var1);
    }
}

