/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdapterVersionStatus;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdapterVersionOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdapterVersionOverview> {
    private static final SdkField<String> ADAPTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterId").getter(AdapterVersionOverview.getter(AdapterVersionOverview::adapterId)).setter(AdapterVersionOverview.setter(Builder::adapterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterId").build()}).build();
    private static final SdkField<String> ADAPTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdapterVersion").getter(AdapterVersionOverview.getter(AdapterVersionOverview::adapterVersion)).setter(AdapterVersionOverview.setter(Builder::adapterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AdapterVersionOverview.getter(AdapterVersionOverview::creationTime)).setter(AdapterVersionOverview.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(AdapterVersionOverview.getter(AdapterVersionOverview::featureTypesAsStrings)).setter(AdapterVersionOverview.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AdapterVersionOverview.getter(AdapterVersionOverview::statusAsString)).setter(AdapterVersionOverview.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(AdapterVersionOverview.getter(AdapterVersionOverview::statusMessage)).setter(AdapterVersionOverview.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_ID_FIELD, ADAPTER_VERSION_FIELD, CREATION_TIME_FIELD, FEATURE_TYPES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adapterId;
    private final String adapterVersion;
    private final Instant creationTime;
    private final List<String> featureTypes;
    private final String status;
    private final String statusMessage;

    private AdapterVersionOverview(BuilderImpl builder) {
        this.adapterId = builder.adapterId;
        this.adapterVersion = builder.adapterVersion;
        this.creationTime = builder.creationTime;
        this.featureTypes = builder.featureTypes;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String adapterId() {
        return this.adapterId;
    }

    public final String adapterVersion() {
        return this.adapterVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final AdapterVersionStatus status() {
        return AdapterVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adapterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterVersionOverview)) {
            return false;
        }
        AdapterVersionOverview other = (AdapterVersionOverview)obj;
        return Objects.equals(this.adapterId(), other.adapterId()) && Objects.equals(this.adapterVersion(), other.adapterVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"AdapterVersionOverview").add("AdapterId", (Object)this.adapterId()).add("AdapterVersion", (Object)this.adapterVersion()).add("CreationTime", (Object)this.creationTime()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterId": {
                return Optional.ofNullable(clazz.cast(this.adapterId()));
            }
            case "AdapterVersion": {
                return Optional.ofNullable(clazz.cast(this.adapterVersion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdapterVersionOverview, T> g) {
        return obj -> g.apply((AdapterVersionOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adapterId;
        private String adapterVersion;
        private Instant creationTime;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AdapterVersionOverview model) {
            this.adapterId(model.adapterId);
            this.adapterVersion(model.adapterVersion);
            this.creationTime(model.creationTime);
            this.featureTypesWithStrings(model.featureTypes);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getAdapterId() {
            return this.adapterId;
        }

        public final void setAdapterId(String adapterId) {
            this.adapterId = adapterId;
        }

        @Override
        public final Builder adapterId(String adapterId) {
            this.adapterId = adapterId;
            return this;
        }

        public final String getAdapterVersion() {
            return this.adapterVersion;
        }

        public final void setAdapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
        }

        @Override
        public final Builder adapterVersion(String adapterVersion) {
            this.adapterVersion = adapterVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AdapterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public AdapterVersionOverview build() {
            return new AdapterVersionOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdapterVersionOverview> {
        public Builder adapterId(String var1);

        public Builder adapterVersion(String var1);

        public Builder creationTime(Instant var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder status(String var1);

        public Builder status(AdapterVersionStatus var1);

        public Builder statusMessage(String var1);
    }
}

