/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information relating to dates in a document, including the type of value, and the value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NormalizedValue implements SdkPojo, Serializable, ToCopyableBuilder<NormalizedValue.Builder, NormalizedValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(NormalizedValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(NormalizedValue::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VALUE_FIELD, VALUE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String valueType;

    private NormalizedValue(BuilderImpl builder) {
        this.value = builder.value;
        this.valueType = builder.valueType;
    }

    /**
     * <p>
     * The value of the date, written as Year-Month-DayTHour:Minute:Second.
     * </p>
     * 
     * @return The value of the date, written as Year-Month-DayTHour:Minute:Second.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The normalized type of the value detected. In this case, DATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link ValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The normalized type of the value detected. In this case, DATE.
     * @see ValueType
     */
    public final ValueType valueType() {
        return ValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The normalized type of the value detected. In this case, DATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link ValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The normalized type of the value detected. In this case, DATE.
     * @see ValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NormalizedValue)) {
            return false;
        }
        NormalizedValue other = (NormalizedValue) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(valueTypeAsString(), other.valueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NormalizedValue").add("Value", value()).add("ValueType", valueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NormalizedValue, T> g) {
        return obj -> g.apply((NormalizedValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NormalizedValue> {
        /**
         * <p>
         * The value of the date, written as Year-Month-DayTHour:Minute:Second.
         * </p>
         * 
         * @param value
         *        The value of the date, written as Year-Month-DayTHour:Minute:Second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The normalized type of the value detected. In this case, DATE.
         * </p>
         * 
         * @param valueType
         *        The normalized type of the value detected. In this case, DATE.
         * @see ValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The normalized type of the value detected. In this case, DATE.
         * </p>
         * 
         * @param valueType
         *        The normalized type of the value detected. In this case, DATE.
         * @see ValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValueType
         */
        Builder valueType(ValueType valueType);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String valueType;

        private BuilderImpl() {
        }

        private BuilderImpl(NormalizedValue model) {
            value(model.value);
            valueType(model.valueType);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(ValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        @Override
        public NormalizedValue build() {
            return new NormalizedValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
